/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone;

import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;

public abstract class OpenStateBlockEntity
extends LodestoneBlockEntity {
    public int closeDelay;

    public OpenStateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void serverTick(ServerLevel level) {
        if (this.closeDelay > 0) {
            --this.closeDelay;
            if (this.closeDelay == 0) {
                this.toggleState(level, false, this.resetState());
            }
        }
    }

    public abstract InboundInfo<? extends OpenStateBlockEntity> resetState();

    public void toggleState(ServerLevel level, boolean newValue, InboundInfo<?> inboundInfo) {
        if (!this.canTinker()) {
            return;
        }
        OpenStateBlockEntity affected = this.getTinkeredBlock();
        if (affected != this) {
            affected.toggleState(level, newValue, inboundInfo);
            return;
        }
        boolean value = (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.OPEN);
        if (value != newValue) {
            level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(!value)), 3);
            level.playSound(null, this.getBlockPos(), value ? (SoundEvent)MalumSoundEvents.SPIRIT_DIODE_CLOSE.get() : (SoundEvent)MalumSoundEvents.SPIRIT_DIODE_OPEN.get(), SoundSource.BLOCKS, 0.8f, RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.9f, (float)1.1f));
            MalumNetworkedParticleEffectType particleEffect = value ? MalumParticleEffectTypes.SPIRIT_DIODE_CLOSE : MalumParticleEffectTypes.SPIRIT_DIODE_OPEN;
            particleEffect.createEffect().at(this.getBlockPos().getCenter().add(0.0, value ? 0.0 : 0.5, 0.0)).color((ColorParticleDataWrapper)ColorParticleData.create((Color)new Color(170, 15, 1), (Color)new Color(129, 12, 0)).build()).spawn(level);
            this.setDirty();
            inboundInfo.sync(affected);
        }
        this.closeDelay = newValue ? 100 : 0;
    }

    public boolean canTinker() {
        return true;
    }

    public OpenStateBlockEntity getTinkeredBlock() {
        return this;
    }

    public static interface InboundInfo<T extends LodestoneBlockEntity> {
        default public void sync(OpenStateBlockEntity entity) {
            this.sync((T)((Object)entity));
        }

        public void sync(T var1);
    }
}

