/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel;

import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WindTunnelBlock
extends AbstractGustGizmoBlock<WindTunnelBlockEntity> {
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.create((String)"right");

    public WindTunnelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, LEFT, RIGHT});
        super.createBlockStateDefinition(builder);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos;
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity((pos = context.getClickedPos()).relative(direction = context.getClickedFace().getOpposite()));
        if (blockEntity instanceof WindTunnelBlockEntity) {
            WindTunnelBlockEntity tunnel = (WindTunnelBlockEntity)blockEntity;
            state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)tunnel.getBlockState().getValue((Property)FACING)));
        }
        return this.updateOcclusion(context.getLevel(), state, context.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        Direction direction = Direction.fromDelta((int)(fromPos.getX() - pos.getX()), (int)(fromPos.getY() - pos.getY()), (int)(fromPos.getZ() - pos.getZ()));
        if (direction != null) {
            level.setBlock(pos, this.updateOcclusion(level, state, pos), 3);
        }
    }

    public BlockState updateOcclusion(Level level, BlockState state, BlockPos pos) {
        Direction[] toCheck = WindTunnelBlock.getRelevantFaces(state);
        for (int i = 0; i < toCheck.length; ++i) {
            WindTunnelBlockEntity neighborTunnel;
            Optional<GustIgniterBlockEntity> optional;
            BlockEntity blockEntity;
            Direction direction = toCheck[i];
            BooleanProperty property = WindTunnelBlock.getDirectionProperty(i);
            BlockPos relative = pos.relative(direction);
            BlockState neighborState = level.getBlockState(relative);
            boolean isValidNeighbor = neighborState.getBlock() instanceof WindTunnelBlock && ((Direction)neighborState.getValue((Property)FACING)).equals((Object)state.getValue((Property)FACING));
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(isValidNeighbor));
            if (!isValidNeighbor || ((Boolean)state.getValue((Property)POWERED)).booleanValue() || !((Boolean)neighborState.getValue((Property)POWERED)).booleanValue() || !((blockEntity = level.getBlockEntity(relative)) instanceof WindTunnelBlockEntity) || !(optional = (neighborTunnel = (WindTunnelBlockEntity)blockEntity).getIgniter()).isPresent()) continue;
            GustIgniterBlockEntity igniter = optional.get();
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
            level.scheduleTick(igniter.getBlockPos(), igniter.getBlockState().getBlock(), 1);
        }
        return state;
    }

    public static boolean isActive(BlockState state) {
        if (!(state.getBlock() instanceof AbstractGustGizmoBlock)) {
            return false;
        }
        return (Boolean)state.getValue((Property)POWERED) != false && (Boolean)state.getValue((Property)OPEN) == false;
    }

    public static Direction[] getRelevantFaces(BlockState state) {
        Direction[] toCheck = new Direction[4];
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing.getAxis().isHorizontal()) {
            toCheck[2] = Direction.UP;
            toCheck[0] = Direction.DOWN;
            toCheck[1] = facing.getClockWise();
            toCheck[3] = facing.getCounterClockWise();
        } else {
            for (int i = 0; i < 4; ++i) {
                Direction direction;
                toCheck[i] = direction = Direction.from2DDataValue((int)i);
            }
            if (facing.equals((Object)Direction.DOWN)) {
                toCheck[1] = toCheck[1].getOpposite();
                toCheck[3] = toCheck[3].getOpposite();
            }
        }
        return toCheck;
    }

    public static BooleanProperty getDirectionProperty(int direction) {
        return switch (direction) {
            case 2 -> UP;
            case 0 -> DOWN;
            case 1 -> LEFT;
            case 3 -> RIGHT;
            default -> throw new IllegalStateException("Unexpected value: " + direction);
        };
    }
}

