/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.waveform;

import com.mojang.blaze3d.platform.InputConstants;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.waveform.AbstractValueConfigurationScreen;
import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import com.sammy.malum.common.payloads.waveform.GustGizmoStateUpdatePayload;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.easing.Easing;

public class GustGizmoConfigurationScreen
extends AbstractValueConfigurationScreen {
    private static final int DIAL_WIDTH = 32;
    private static final int DIAL_HEIGHT = 64;
    protected static final ResourceLocation DIAL_TEXTURE = MalumMod.malumPath("textures/gui/waveform_artifice/gust_gizmo_configuration_dial.png");
    protected static final ResourceLocation DIAL_OVERLAY = MalumMod.malumPath("textures/gui/waveform_artifice/gust_gizmo_configuration_dial_overlay.png");
    private final GustIgniterBlockEntity gustIgniter;
    private final boolean isTunnel;
    private float displayedStrength;
    private int oldStrength;
    private int strength;
    private boolean modified;

    public GustGizmoConfigurationScreen(GustIgniterBlockEntity gustIgniter, boolean isTunnel) {
        super(GustGizmoConfigurationScreen.getTitleComponent(gustIgniter), 212, 124, 32, 64);
        this.gustIgniter = gustIgniter;
        this.isTunnel = isTunnel;
        this.strength = gustIgniter.strength;
        this.modified = gustIgniter.modified;
    }

    public static Component getTitleComponent(LodestoneBlockEntity blockEntity) {
        if (blockEntity instanceof GustIgniterBlockEntity) {
            GustIgniterBlockEntity igniter = (GustIgniterBlockEntity)blockEntity;
            BlockPos igniterPos = igniter.getBlockPos();
            Direction facing = (Direction)igniter.getBlockState().getValue((Property)GustIgniterBlock.FACING);
            BlockPos tunnelPos = igniterPos.relative(facing);
            BlockEntity blockEntity2 = igniter.getLevel().getBlockEntity(tunnelPos);
            if (blockEntity2 instanceof WindTunnelBlockEntity) {
                WindTunnelBlockEntity tunnel = (WindTunnelBlockEntity)blockEntity2;
                return AbstractValueConfigurationScreen.getTitleComponent(tunnel);
            }
        }
        return AbstractValueConfigurationScreen.getTitleComponent(blockEntity);
    }

    @Override
    protected void notifyServer(boolean isOpen) {
        PacketDistributor.sendToServer((CustomPacketPayload)new GustGizmoStateUpdatePayload(this.gustIgniter.getBlockPos(), isOpen, new AbstractGustGizmoBlockEntity.GustGizmoInfo(this.strength, this.modified)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void updateMousePosition(double mouseX, double mouseY) {
        double newMouseX = Mth.clamp((double)mouseX, (double)this.dialLeft, (double)this.dialRight);
        double newMouseY = this.dialBottom - this.strength * 2;
        this.setCursor(newMouseX, newMouseY);
    }

    @Override
    protected boolean hasChanged() {
        if (this.oldStrength != this.strength) {
            this.oldStrength = this.strength;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.disableMouse && GustGizmoConfigurationScreen.isHovering(mouseX, mouseY, this.dialLeft, this.dialTop, 32, 64)) {
            double offsetY = ((double)this.dialBottom - mouseY) / 2.0;
            this.strength = this.clampStrength(Mth.ceil((double)offsetY));
        }
        this.disableMouse = false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.modified = !this.modified;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.strength = this.clampStrength(this.strength + (scrollY > 0.0 ? 1 : -1));
        this.updateMousePosition(mouseX, mouseY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (i = 0; i < 3; ++i) {
            MutableComponent guideText = Component.translatable((String)("malum.waveform_artifice.guide." + i));
            int y = this.guiTop + this.screenHeight - 10 * (3 - i);
            guiGraphics.drawString(this.font, (Component)guideText, this.xCenter - this.font.width((FormattedText)guideText) / 2, y, 0xDDDDDD, false);
        }
        for (i = 0; i < 2; ++i) {
            boolean isModified = i == 1;
            Component text = this.getModeText(isModified);
            this.renderTextWidget(guiGraphics, text, this.dialLeft - 5, this.dialTop + 13 * i, isModified == this.modified, partialTick);
        }
        this.renderBorderBackground(guiGraphics, this.dialLeft, this.dialTop, 32, 64);
        this.renderDial(guiGraphics, this.dialLeft, this.dialTop);
        this.renderBorder(guiGraphics, this.dialLeft, this.dialTop, 32, 64);
        MutableComponent text = Component.literal((String)FORMAT.format(this.strength));
        float f = (float)this.xDialCenter + 0.5f - (float)this.font.width((FormattedText)text) / 2.0f;
        float f2 = (float)this.yDialCenter + 0.5f;
        Objects.requireNonNull(this.font);
        this.renderText(guiGraphics, (Component)text, f, f2 - 9.0f / 2.0f, true, partialTick);
    }

    @Override
    public void tick() {
        this.displayedStrength = Mth.lerp((float)0.1f, (float)this.displayedStrength, (float)this.strength);
        super.tick();
    }

    public void renderDial(GuiGraphics graphics, int x, int y) {
        this.renderDial(graphics, DIAL_TEXTURE, x, y);
        float delta = this.displayedStrength / 32.0f;
        float range = Easing.QUAD_IN.ease(delta, 90.0f, 270.0f);
        float alpha = Easing.EXPO_IN_OUT.ease(delta, 0.25f, 1.0f);
        this.renderDialOverlay(graphics, DIAL_TEXTURE, x, y, 0, range, alpha);
    }

    public int clampStrength(int strength) {
        int newStrength = strength;
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344)) {
            newStrength = this.oldStrength > strength ? Mth.floor((float)((float)strength / 4.0f)) * 4 : Mth.ceil((float)((float)strength / 4.0f)) * 4;
        }
        int min = 1;
        int max = Mth.floor((float)32.0f);
        return Mth.clamp((int)newStrength, (int)min, (int)max);
    }

    public Component getModeText(boolean isModified) {
        ComponentContents componentContents = this.title.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            return Component.translatable((String)(contents.getKey() + "." + (isModified ? "alt" : "default")));
        }
        throw new IllegalArgumentException();
    }
}

