/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.common.recipe.UnchainedTransmutationRecipe;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class UnchainedTransmutationRecipePage
extends BookPage {
    private final Component headline;
    private final List<UnchainedTransmutationRecipe> recipes;

    public UnchainedTransmutationRecipePage(String headline, Predicate<UnchainedTransmutationRecipe> predicate) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_page.png"));
        this.headline = Component.translatable((String)("malum.gui.book.entry.page.headline." + headline));
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            this.recipes = new ArrayList<UnchainedTransmutationRecipe>();
            UnchainedTransmutationRecipe recipe = (UnchainedTransmutationRecipe)LodestoneRecipeType.findRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.UNCHAINED_TRANSMUTATION.get()), predicate);
            if (recipe != null) {
                this.recipes.add(recipe);
                if (recipe.group != null) {
                    for (UnchainedTransmutationRecipe otherRecipe : LodestoneRecipeType.getRecipes((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.UNCHAINED_TRANSMUTATION.get()))) {
                        if (((Object)((Object)recipe)).equals((Object)otherRecipe) || !recipe.group.equals(otherRecipe.group)) continue;
                        this.recipes.add(otherRecipe);
                    }
                }
            }
        } else {
            this.recipes = null;
        }
    }

    public static UnchainedTransmutationRecipePage fromInput(String headlineTranslationKey, Item inputItem) {
        return new UnchainedTransmutationRecipePage(headlineTranslationKey, s -> s.ingredient.test(inputItem.getDefaultInstance()));
    }

    public static UnchainedTransmutationRecipePage fromOutput(String headlineTranslationKey, Item outputItem) {
        return new UnchainedTransmutationRecipePage(headlineTranslationKey, s -> s.output.is(outputItem));
    }

    @Override
    public boolean isValid() {
        return this.recipes != null;
    }

    @Override
    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        CodexTextHelper.renderHeadline(guiGraphics, this.headline, left, top);
        UnchainedTransmutationRecipe recipe = this.recipes.get(this.getIndex());
        CodexItemHelper.renderIngredient((AbstractMalumCodexScreen)screen, guiGraphics, recipe.ingredient, left + 63, top + 56, mouseX, mouseY);
        CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, recipe.output, left + 63, top + 132, mouseX, mouseY);
        this.renderRecipeInfo(guiGraphics, screen, "unchained_transmutation", left + 62, top + 78, mouseX, mouseY);
    }

    public int getIndex() {
        return (int)(Minecraft.getInstance().level.getGameTime() % (20L * (long)this.recipes.size()) / 20L);
    }
}

