/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects.progression;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.PlacedEntryAcceptor;
import com.sammy.malum.client.screen.codex.handlers.SubspaceEntryObjectHandler;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.RiteEntryObject;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.client.MalumScreenParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class SubspaceEntryObject
extends ProgressionEntryObject {
    private static final ResourceLocation SUBSPACE_TEXTURE = MalumMod.malumPath("textures/gui/book/subspace_container.png");
    private static final ResourceLocation GLOW_TEXTURE = MalumMod.malumPath("textures/gui/book/subentry_glow.png");
    private static final ResourceLocation ICON_LEFT_TEXTURE = MalumMod.malumPath("textures/gui/book/subentry_icon_left.png");
    private static final ResourceLocation ICON_RIGHT_TEXTURE = MalumMod.malumPath("textures/gui/book/subentry_icon_right.png");
    private static final int WARMUP_TIME = 16;
    protected final ScreenParticleHolder entryParticles = new ScreenParticleHolder();
    protected final ScreenParticleHolder subspaceParticles = new ScreenParticleHolder();
    protected final SubspaceEntryObjectHandler objects = new SubspaceEntryObjectHandler();
    protected final List<PlacedBookEntry> entries;
    protected final int subspaceSize;
    @Nullable
    protected final SpiritRiteType riteType;
    protected boolean assembledObjects = false;
    protected boolean isActive = false;
    protected int activeDuration;

    public SubspaceEntryObject(BookEntry entry, int posX, int posY, List<PlacedBookEntry> entries, int subspaceSize) {
        super(entry, posX, posY);
        this.entries = ImmutableList.copyOf(entries);
        this.subspaceSize = subspaceSize;
        this.riteType = entries.stream().findAny().map(RiteEntryObject::getRiteTypeFromEntry).flatMap(o -> o).orElse(null);
    }

    @Override
    public boolean hasPriority(AbstractProgressionCodexScreen screen) {
        return this.isActive;
    }

    @Override
    public void tick(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        int centerX = this.getCenterX();
        int centerY = this.getCenterY();
        this.spawnEntryParticles();
        this.entryParticles.tick();
        if (this.isActive || this.activeDuration > 0) {
            this.spawnSubspaceParticles();
            this.subspaceParticles.tick();
        }
        if (this.isActive) {
            int xDiff = centerX - (int)mouseX;
            int yDiff = centerY - (int)mouseY;
            double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
            if (distance > (double)this.subspaceSize / 2.0 + 16.0) {
                screen.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_SUBENTRY_CLOSE, 0.75f);
                this.isActive = false;
            }
            if (this.activeDuration < 16) {
                ++this.activeDuration;
            }
            this.objects.tick(screen, mouseX, mouseY);
        } else {
            if (this.activeDuration > 0) {
                --this.activeDuration;
            }
            super.tick(screen, mouseX, mouseY);
        }
    }

    @Override
    public void render(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(screen, guiGraphics, mouseX, mouseY, partialTicks);
        this.entryParticles.render(guiGraphics);
        int posX = this.getOffsetXPosition();
        int posY = this.getOffsetYPosition();
        SubspaceEntryObject.renderGlow(guiGraphics, posX, posY, this.entry.associatedSpirit);
        PoseStack pose = guiGraphics.pose();
        if (this.riteType != null) {
            CodexRenderHelper.renderRiteIcon(this.riteType, pose, this.getOffsetXPosition() + 8, this.getOffsetYPosition() + 8);
        } else {
            Set spirits = this.entries.stream().map(e -> e.associatedSpirit).filter(Objects::nonNull).collect(Collectors.toSet());
            for (int i = 0; i < 2; ++i) {
                ResourceLocation texture = i == 0 ? ICON_LEFT_TEXTURE : ICON_RIGHT_TEXTURE;
                SpiritLike spirit = spirits.stream().findFirst().orElse(this.entry.associatedSpirit);
                if (spirit == null) continue;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                CodexRenderHelper.renderSpiritIcon(texture, pose, spirit, false, this.getOffsetXPosition(), this.getOffsetYPosition(), 0, 32, 32);
                for (int j = 0; j < 4; ++j) {
                    float angle = (float)j / 4.0f * 6.28f + ((float)Minecraft.getInstance().level.getGameTime() + partialTicks) * 0.05f % 6.28f;
                    float offsetScale = 2.5f;
                    float offsetX = (float)this.getOffsetXPosition() + Mth.sin((float)angle) * offsetScale;
                    float offsetY = (float)this.getOffsetYPosition() + Mth.cos((float)angle) * offsetScale;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                    CodexRenderHelper.renderSpiritIcon(texture, pose, spirit, j % 2 == 0, offsetX, offsetY, 0, 32, 32);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                spirits.remove(spirit);
            }
        }
    }

    @Override
    public void renderLate(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive || this.activeDuration > 0) {
            PoseStack pose = guiGraphics.pose();
            float duration = this.activeDuration;
            if (this.isActive) {
                if (duration < 16.0f) {
                    duration += partialTicks;
                }
            } else {
                duration -= partialTicks;
            }
            float delta = Easing.SINE_IN_OUT.ease(Math.min(0.1f + duration / 16.0f, 1.0f), 0.0f, 1.0f);
            Minecraft minecraft = Minecraft.getInstance();
            int scale = (int)minecraft.getWindow().getGuiScale();
            int size = (int)((float)this.subspaceSize * delta);
            int offset = size / 2;
            int x = this.getOffsetXPosition() + this.width / 2 - offset;
            int y = this.getOffsetYPosition() + this.height / 2 - offset;
            int margin = 6;
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 500.0f);
            SubspaceEntryObject.renderSubspace(guiGraphics, x - margin, y - margin, size + margin * 2, delta);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(x * scale), (int)(minecraft.getWindow().getHeight() - (y + size) * scale), (int)(size * scale), (int)(size * scale));
            this.subspaceParticles.render();
            screen.captureLateRendering();
            this.objects.renderObjects(screen, guiGraphics, this.xOffset, this.yOffset, mouseX, mouseY, partialTicks);
            GL11.glDisable((int)3089);
            if (this.isActive) {
                this.objects.renderObjectsLate(screen, guiGraphics, mouseX, mouseY, partialTicks);
            }
            screen.doLateRendering();
            pose.popPose();
        } else {
            super.renderLate(screen, guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean tryClick(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        if (!this.assembledObjects) {
            this.objects.setupEntryObjects(screen, this.entries);
            this.assembledObjects = true;
        }
        if (this.isActive) {
            return this.objects.click(screen, mouseX, mouseY);
        }
        return super.tryClick(screen, mouseX, mouseY);
    }

    @Override
    public boolean click(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        for (BookObject object : screen.progressionObjects.getObjects()) {
            SubspaceEntryObject otherSubspace;
            if (!(object instanceof SubspaceEntryObject) || (otherSubspace = (SubspaceEntryObject)object) == this || !otherSubspace.isActive) continue;
            return false;
        }
        if (!this.isActive) {
            screen.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_SUBENTRY_OPEN, 1.25f);
            this.isActive = true;
            return true;
        }
        return super.click(screen, mouseX, mouseY);
    }

    public void spawnEntryParticles() {
        SpiritLike spirit = this.entry.associatedSpirit;
        if (spirit == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        RandomSource rand = level.random;
        if (level.getGameTime() % 4L == 0L) {
            for (int i = 0; i < 3; ++i) {
                float angle = ((float)level.getGameTime() * 1.5f + (float)(i * 120)) / 360.0f * 6.28f % 6.28f;
                int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)100, (int)140);
                ScreenParticleBuilder.create(MalumScreenParticles.LIGHT_SPEC, (ScreenParticleHolder)this.entryParticles).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)rand, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.05f, (float)0.2f), (float)0.0f).randomSpinOffset(rand).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.9f), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)spirit.createColorData().setCoefficient(0.9f)).setLifetime(lifetime).addRenderActor(p -> {
                    float distance = 7.5f;
                    float ageDelta = (float)p.age / (float)p.lifetime;
                    float updatedAngle = angle + ageDelta * 0.05f;
                    p.x = (double)this.getCenterX() + Math.sin(updatedAngle) * (double)distance;
                    p.y = (double)this.getCenterY() + Math.cos(updatedAngle) * (double)distance;
                }).spawn(0.0, 0.0);
            }
        }
    }

    public void spawnSubspaceParticles() {
        SpiritLike spirit = this.entry.associatedSpirit;
        if (spirit == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        RandomSource rand = level.random;
        float distance = (float)(this.subspaceSize - 20) * 0.5f;
        float finalDistance = distance * RandomHelper.randomBetween((RandomSource)rand, (float)0.6f, (float)1.2f);
        for (int i = 0; i < 4; ++i) {
            float angle = ((float)level.getGameTime() * 8.2f + (float)(i * 80)) / 320.0f * 6.28f % 6.28f;
            int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)200, (int)400);
            ScreenParticleBuilder.create(MalumScreenParticles.LIGHT_SPEC, (ScreenParticleHolder)this.subspaceParticles).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)rand, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.05f, (float)0.2f), (float)0.0f).randomSpinOffset(rand).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)1.5f), (float)0.0f).setEasing(Easing.EXPO_IN).build()).setColorData((ColorParticleDataWrapper)spirit.createColorData().setCoefficient(0.9f)).setLifetime(lifetime).addRenderActor(p -> {
                float ageDelta = (float)p.age / (float)p.lifetime;
                float updatedAngle = angle + ageDelta * 0.05f;
                float updatedDistance = Mth.clampedLerp((float)distance, (float)finalDistance, (float)ageDelta);
                p.x = (double)this.getCenterX() + Math.sin(updatedAngle) * (double)updatedDistance;
                p.y = (double)this.getCenterY() + Math.cos(updatedAngle) * (double)updatedDistance;
            }).repeat(0.0, 0.0, 2);
        }
    }

    public static void renderGlow(GuiGraphics graphics, int x, int y, @Nullable SpiritLike spirit) {
        if (spirit == null) {
            return;
        }
        ExtendedShaderInstance shaderInstance = LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(10.0f);
        shaderInstance.safeGetUniform("Speed").set(600.0f);
        shaderInstance.safeGetUniform("Intensity").set(100.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(-1.0f, 2.0f, -1.0f, 2.0f));
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setColor(spirit.getPrimaryColor()).setAlpha(0.3f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        SubspaceEntryObject.renderGlowTexture(graphics, builder, x, y);
        builder.setAlpha(0.1f);
        RenderSystem.blendFunc((int)770, (int)1);
        shaderInstance.safeGetUniform("Speed").set(800.0f);
        SubspaceEntryObject.renderGlowTexture(graphics, builder, x - 1, y);
        SubspaceEntryObject.renderGlowTexture(graphics, builder, x + 1, y);
        SubspaceEntryObject.renderGlowTexture(graphics, builder, x, y - 1);
        builder.setColor(spirit.getSecondaryColor());
        SubspaceEntryObject.renderGlowTexture(graphics, builder, x, y + 1);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderSubspace(GuiGraphics graphics, int x, int y, int size, float delta) {
        ExtendedShaderInstance shaderInstance = LodestoneShaders.MANUAL_NINE_SLICE.getShaderInstance();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(10.0f);
        shaderInstance.safeGetUniform("Speed").set(400.0f);
        shaderInstance.safeGetUniform("Intensity").set(100.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(-1.0f, 2.0f, -1.0f, 2.0f));
        shaderInstance.safeGetUniform("Size").set(3.0f, 3.0f);
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader((ShaderInstance)shaderInstance).setAlpha(delta);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        SubspaceEntryObject.renderSubspaceTexture(graphics, builder, x, y, size);
        builder.setAlpha(0.2f * delta);
        RenderSystem.blendFunc((int)770, (int)1);
        shaderInstance.safeGetUniform("Speed").set(800.0f);
        SubspaceEntryObject.renderSubspaceTexture(graphics, builder, x - 1, y, size);
        SubspaceEntryObject.renderSubspaceTexture(graphics, builder, x + 1, y, size);
        SubspaceEntryObject.renderSubspaceTexture(graphics, builder, x, y - 1, size);
        SubspaceEntryObject.renderSubspaceTexture(graphics, builder, x, y + 1, size);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderSubspaceTexture(GuiGraphics graphics, VFXBuilders.ScreenVFXBuilder builder, int x, int y, int size) {
        builder.setTexture(SUBSPACE_TEXTURE).setPositionWithWidth((float)x, (float)y, (float)size, (float)size).blit(graphics.pose());
    }

    public static void renderGlowTexture(GuiGraphics graphics, VFXBuilders.ScreenVFXBuilder builder, int x, int y) {
        builder.setTexture(GLOW_TEXTURE).setPositionWithWidth((float)x, (float)y, 32.0f, 32.0f).blit(graphics.pose());
    }

    public static class SubspaceWidgetSupplier
    implements PlacedBookEntry.WidgetSupplier,
    PlacedEntryAcceptor {
        protected final List<PlacedBookEntry> entries = new ArrayList<PlacedBookEntry>();
        protected int size = 160;

        public SubspaceWidgetSupplier setSize(int size) {
            this.size = size;
            return this;
        }

        public List<PlacedBookEntry> getEntries() {
            return this.entries;
        }

        @Override
        public ProgressionEntryObject getBookObject(BookEntry entry, int x, int y) {
            return new SubspaceEntryObject(entry, x, y, this.entries, this.size);
        }
    }
}

