/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.entity.activator.SpiritCollectionActivatorEntity;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class SpiritCollectionActivatorEntityRenderer
extends EntityRenderer<SpiritCollectionActivatorEntity> {
    public final ItemRenderer itemRenderer;

    public SpiritCollectionActivatorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public void render(SpiritCollectionActivatorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        SpiritHolder<SpiritArcanaType> spiritType = MalumSpiritTypes.UMBRAL_SPIRIT;
        SpiritHolder<SpiritArcanaType> secondarySpiritType = MalumSpiritTypes.ELDRITCH_SPIRIT;
        LodestoneRenderTypeBuilder additive = LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        LodestoneRenderTypeBuilder transparent = LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        VFXBuilders.WorldVFXBuilder trailBuilder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType(additive);
        float yOffset = entity.getYOffset(partialTicks);
        for (int i = 0; i < 2; ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)yOffset, 0.0);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, secondarySpiritType, 1.0f, 0.1f, partialTicks);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, secondarySpiritType, 0.2f, 0.7f, partialTicks);
            FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spiritType, 2.0f, 3.0f, partialTicks);
            poseStack.popPose();
            Color primaryColor = spiritType.getPrimaryColor();
            Color secondaryColor = spiritType.getSecondaryColor();
            RenderUtils.renderEntityTrail(poseStack, trailBuilder, entity.trail, (Entity)entity, primaryColor, secondaryColor, 0.7f, 1.0f, partialTicks);
            RenderUtils.renderEntityTrail(poseStack, trailBuilder, entity.longTrail, (Entity)entity, primaryColor, secondaryColor, 0.4f, 0.3f, partialTicks);
            for (TrailPointBuilder trail : entity.orbitingTrails) {
                RenderUtils.renderEntityTrail(poseStack, trailBuilder, trail, (Entity)entity, primaryColor, secondaryColor, 0.9f, 1.0f, partialTicks);
            }
            trailBuilder.setRenderType(transparent);
            RenderUtils.renderEntityTrail(poseStack, trailBuilder, entity.trail, (Entity)entity, primaryColor, secondaryColor, 0.7f, 1.25f, partialTicks);
            RenderUtils.renderEntityTrail(poseStack, trailBuilder, entity.longTrail, (Entity)entity, primaryColor, secondaryColor, 0.2f, 0.5f, partialTicks);
            for (TrailPointBuilder trail : entity.orbitingTrails) {
                RenderUtils.renderEntityTrail(poseStack, trailBuilder, trail, (Entity)entity, primaryColor, secondaryColor, 0.4f, 1.25f, partialTicks);
            }
        }
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(SpiritCollectionActivatorEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

