/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.obelisk.rite_pylon.ArcanaPylonBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class ArcanaPylonRenderer
implements BlockEntityRenderer<ArcanaPylonBlockEntity> {
    public ArcanaPylonRenderer(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(ArcanaPylonBlockEntity blockEntityIn) {
        BlockPos pos = blockEntityIn.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 5), (double)(pos.getZ() + 2));
    }

    public void render(ArcanaPylonBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SpiritArcanaType spiritType;
        ClientLevel level = Minecraft.getInstance().level;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = blockEntityIn.getInventory().getStackInSlot(0);
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            Vec3 offset = blockEntityIn.getCentralItemOffset();
            poseStack.translate(offset.x, offset.y, offset.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)(level.getGameTime() % 360L) + partialTicks) * 3.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, (Level)level, 0);
            poseStack.popPose();
        }
        if ((spiritType = blockEntityIn.getSpirit()) == null) {
            return;
        }
        float delta = blockEntityIn.getGlowDelta();
        float ease = Easing.SINE_OUT.ease(delta, 0.0f, 1.0f, 1.0f);
        float offsetDistance = 0.2f - ease * 0.2f;
        float wobbleStrength = 0.1f - ease * 0.075f;
        float gameTime = (float)level.getGameTime() + partialTicks;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        for (int i = 0; i < 5; ++i) {
            float alpha = delta * 0.7f;
            RenderTypeToken token = i == 4 ? MalumRenderTypeTokens.PYLON_GLOW_TOP : MalumRenderTypeTokens.PYLON_GLOW_SIDE;
            LodestoneRenderTypeBuilder renderType = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(token);
            Vector3f[] vertices = ArcanaPylonRenderer.getVertexPositions(i);
            poseStack.pushPose();
            if (i < 4) {
                poseStack.mulPose(Axis.YN.rotationDegrees((float)(i * 90)));
            }
            int time = 160;
            for (int j = 0; j < 4; ++j) {
                Color color = j <= 1 ? spiritType.getPrimaryColor() : spiritType.getSecondaryColor();
                double offset = 0.0;
                if (offsetDistance > 0.0f) {
                    double angle = (double)((float)j / 4.0f) * (Math.PI * 2);
                    offset = (double)offsetDistance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                    if (j % 2 == 0) {
                        offset *= -1.0;
                    }
                }
                poseStack.pushPose();
                poseStack.translate(offset, 0.0, 0.0);
                CubeVertexData.applyVertexWobble((Vector3f[])vertices, (float)((float)j * 2.0f), (float)wobbleStrength);
                SpiritBasedWorldVFXBuilder.create(spiritType).setColor(color, alpha).setRenderType(renderType).renderQuad(poseStack, vertices, 1.0f);
                poseStack.popPose();
                alpha *= 1.0f - (delta + 0.2f) * 0.4f;
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static Vector3f @NotNull [] getVertexPositions(int direction) {
        Vector3f[] positions = direction < 4 ? new Vector3f[]{new Vector3f(-0.5f, 0.625f, 0.35f), new Vector3f(0.5f, 0.625f, 0.35f), new Vector3f(0.5f, 1.625f, 0.35f), new Vector3f(-0.5f, 1.625f, 0.35f)} : new Vector3f[]{new Vector3f(-0.5f, 1.65f, 0.5f), new Vector3f(0.5f, 1.65f, 0.5f), new Vector3f(0.5f, 1.65f, -0.5f), new Vector3f(-0.5f, 1.65f, -0.5f)};
        return positions;
    }
}

