/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.sound;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

public class SoundMotifSoundType
extends ExtendedSoundType {
    public final Supplier<SoundEvent> motifSound;

    public SoundMotifSoundType(Supplier<SoundEvent> motifSound, float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        super(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
        this.motifSound = motifSound;
    }

    public float getMotifPitch() {
        return this.getPitch();
    }

    public float getMotifVolume() {
        return this.getVolume();
    }

    @Override
    public void onPlayBreakSound(Level level, BlockPos pos) {
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.motifSound.get(), SoundSource.BLOCKS, (this.getMotifVolume() + 1.0f) / 4.0f, this.getMotifPitch() * 0.6f, false);
    }

    @Override
    public void onPlayStepSound(Level level, BlockPos pos, BlockState state, SoundSource category) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.motifSound.get(), category, this.getMotifVolume() * 0.1f, this.getMotifPitch());
    }

    @Override
    public void onPlayPlaceSound(Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, this.motifSound.get(), SoundSource.BLOCKS, (this.getMotifVolume() + 1.0f) / 4.0f, this.getMotifPitch() * 0.8f);
    }

    @Override
    public void onPlayHitSound(BlockPos pos) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(this.motifSound.get(), SoundSource.BLOCKS, (this.getMotifVolume() + 1.0f) / 8.0f, this.getMotifPitch() * 0.5f, SoundInstance.createUnseededRandom(), pos));
    }

    @Override
    public void onPlayFallSound(Level level, BlockPos pos, SoundSource category) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.motifSound.get(), category, this.getMotifVolume() * 0.5f, this.getMotifPitch() * 0.75f);
    }
}

