/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class LodestoneProgram {
    private static final int MAX_LOG_LENGTH = 32768;
    private final Type type;
    private final String name;
    private int id;

    private LodestoneProgram(Type type, int id, String name) {
        this.type = type;
        this.id = id;
        this.name = name;
    }

    public void attachToShader(Shader shader) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.glAttachShader((int)shader.getId(), (int)this.getId());
    }

    public void close() {
        if (this.id != -1) {
            RenderSystem.assertOnRenderThread();
            GlStateManager.glDeleteShader((int)this.id);
            this.id = -1;
            this.type.getPrograms().remove(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public static LodestoneProgram compileShader(Type type, String name, InputStream shaderData, String sourceName, GlslPreprocessor preprocessor) throws IOException {
        RenderSystem.assertOnRenderThread();
        int i = LodestoneProgram.compileShaderInternal(type, name, shaderData, sourceName, preprocessor);
        LodestoneProgram program = new LodestoneProgram(type, i, name);
        type.getPrograms().put(name, program);
        return program;
    }

    protected static int compileShaderInternal(Type type, String name, InputStream shaderData, String sourceName, GlslPreprocessor preprocessor) throws IOException {
        String s = IOUtils.toString((InputStream)shaderData, (Charset)StandardCharsets.UTF_8);
        if (s == null) {
            throw new IOException("Could not load program " + type.getName());
        }
        int i = GlStateManager.glCreateShader((int)type.getGlType());
        GlStateManager.glShaderSource((int)i, (List)preprocessor.process(s));
        GlStateManager.glCompileShader((int)i);
        if (GlStateManager.glGetShaderi((int)i, (int)35713) == 0) {
            String s1 = StringUtils.trim((String)GlStateManager.glGetShaderInfoLog((int)i, (int)32768));
            throw new IOException("Couldn't compile " + type.getName() + " program (" + sourceName + ", " + name + ") : " + s1);
        }
        return i;
    }

    protected int getId() {
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        VERTEX("vertex", ".vsh", 35633),
        FRAGMENT("fragment", ".fsh", 35632),
        GEOMETRY("geometry", ".gsh", 36313);

        private final String name;
        private final String extension;
        private final int glType;
        private final Map<String, LodestoneProgram> programs = Maps.newHashMap();

        private Type(String name, String extension, int glType) {
            this.name = name;
            this.extension = extension;
            this.glType = glType;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        int getGlType() {
            return this.glType;
        }

        public Map<String, LodestoneProgram> getPrograms() {
            return this.programs;
        }
    }
}

