/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.enchanting;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;

public class LodestoneEnchantmentEffectActivator<T> {
    private final Either<DataComponentType<List<ConditionalEffect<T>>>, DataComponentType<List<TargetedConditionalEffect<T>>>> componentType;
    private final ServerLevel level;
    private ContextSupplier contextSupplier;

    public static <T> LodestoneEnchantmentEffectActivator<T> createEffectActivator(DataComponentType<List<ConditionalEffect<T>>> componentType, ServerLevel level) {
        return new LodestoneEnchantmentEffectActivator<T>(Either.left(componentType), level);
    }

    public static <T> LodestoneEnchantmentEffectActivator<T> createTargetedEffectActivator(DataComponentType<List<TargetedConditionalEffect<T>>> componentType, ServerLevel level) {
        return new LodestoneEnchantmentEffectActivator<T>(Either.right(componentType), level);
    }

    private LodestoneEnchantmentEffectActivator(Either<DataComponentType<List<ConditionalEffect<T>>>, DataComponentType<List<TargetedConditionalEffect<T>>>> componentType, ServerLevel level) {
        this.componentType = componentType;
        this.level = level;
    }

    public LodestoneEnchantmentEffectActivator<T> setItemContext(ItemStack enchantedItem) {
        return this.setContext(enchantmentLevel -> Enchantment.itemContext((ServerLevel)this.level, (int)enchantmentLevel, (ItemStack)enchantedItem));
    }

    public LodestoneEnchantmentEffectActivator<T> setDamageContext(ServerLevel level, Entity attackedEntity, DamageSource damageSource, @Nullable ItemStack enchantedItem) {
        return this.setContext(enchantmentLevel -> LodestoneEnchantmentEffectActivator.damageContext(level, enchantmentLevel, attackedEntity, damageSource, enchantedItem));
    }

    public LodestoneEnchantmentEffectActivator<T> setEntityContext(ServerLevel level, Entity entity, @Nullable ItemStack enchantedItem) {
        return this.setEntityContext(level, entity, entity.position(), enchantedItem);
    }

    public LodestoneEnchantmentEffectActivator<T> setEntityContext(ServerLevel level, Entity entity, Vec3 origin, @Nullable ItemStack enchantedItem) {
        return this.setContext(enchantmentLevel -> LodestoneEnchantmentEffectActivator.entityContext(level, enchantmentLevel, entity, origin, enchantedItem));
    }

    public LodestoneEnchantmentEffectActivator<T> setContext(ContextSupplier contextSupplier) {
        this.contextSupplier = contextSupplier;
        return this;
    }

    public void triggerEntityEffects(ItemStack enchantedItem, LivingEntity target) {
        this.triggerEntityEffects(enchantedItem, target, (Entity)target);
    }

    public void triggerEntityEffects(ItemStack enchantedItem, LivingEntity enchanted, Entity target) {
        this.triggerEntityEffects(new EnchantedItemInUse(enchantedItem, null, enchanted, item -> {}), target);
    }

    public void triggerEntityEffects(EnchantedItemInUse enchantedItem, Entity target) {
        this.applyEffects((effect, entity, enchantmentLevel) -> {
            if (effect instanceof EnchantmentEntityEffect) {
                EnchantmentEntityEffect entityEffect = (EnchantmentEntityEffect)effect;
                entityEffect.apply(this.level, enchantmentLevel, enchantedItem, entity, entity.position());
            }
        }, enchantedItem.itemStack(), target);
    }

    public float countValue(ItemStack enchantedItem, Entity target) {
        return this.modifyValue(enchantedItem, target, 0.0f);
    }

    public float modifyValue(ItemStack enchantedItem, Entity target, float baseValue) {
        MutableFloat value = new MutableFloat(baseValue);
        this.applyEffects((effect, entity, enchantmentLevel) -> {
            if (effect instanceof EnchantmentValueEffect) {
                EnchantmentValueEffect valueEffect = (EnchantmentValueEffect)effect;
                value.setValue(valueEffect.process(enchantmentLevel, this.level.getRandom(), value.getValue().floatValue()));
            }
        }, enchantedItem, target);
        return value.getValue().floatValue();
    }

    public float countValue(LivingEntity target) {
        return this.modifyValue(target, 0.0f);
    }

    public float modifyValue(LivingEntity target, float baseValue) {
        MutableFloat value = new MutableFloat(baseValue);
        this.applyEffects((effect, entity, enchantmentLevel) -> {
            if (effect instanceof EnchantmentValueEffect) {
                EnchantmentValueEffect valueEffect = (EnchantmentValueEffect)effect;
                value.setValue(valueEffect.process(enchantmentLevel, this.level.getRandom(), value.getValue().floatValue()));
            }
        }, target);
        return value.getValue().floatValue();
    }

    public boolean hasEffect(ItemStack enchantedItem, Entity target) {
        AtomicBoolean hasEffect = new AtomicBoolean(false);
        this.applyEffects((effect, entity, enchantmentLevel) -> hasEffect.set(true), enchantedItem, target);
        return hasEffect.get();
    }

    public void applyEffects(EnchantmentEffectAcceptor<T> acceptor, ItemStack enchantedItem, Entity target) {
        if (this.contextSupplier == null) {
            throw new IllegalStateException("Context is not set");
        }
        EnchantmentHelper.runIterationOnItem((ItemStack)enchantedItem, (enchantment, enchantmentLevel) -> {
            LootContext context = this.contextSupplier.getContext(enchantmentLevel);
            this.componentType.ifLeft(componentType -> {
                for (ConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(componentType)) {
                    if (!effect.matches(context)) continue;
                    acceptor.apply(effect.effect(), target, enchantmentLevel);
                }
            });
            this.componentType.ifRight(componentType -> {
                for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(componentType)) {
                    Entity entity;
                    if (!effect.matches(context)) continue;
                    DamageSource source = (DamageSource)context.getParam(LootContextParams.DAMAGE_SOURCE);
                    if ((entity = (switch (effect.affected()) {
                        default -> throw new MatchException(null, null);
                        case EnchantmentTarget.ATTACKER -> source.getEntity();
                        case EnchantmentTarget.DAMAGING_ENTITY -> source.getDirectEntity();
                        case EnchantmentTarget.VICTIM -> target;
                    })) == null) continue;
                    acceptor.apply(effect.effect(), entity, enchantmentLevel);
                }
            });
        });
    }

    public void applyEffects(EnchantmentEffectAcceptor<T> acceptor, LivingEntity target) {
        if (this.contextSupplier == null) {
            throw new IllegalStateException("Context is not set");
        }
        EnchantmentHelper.runIterationOnEquipment((LivingEntity)target, (enchantment, enchantmentLevel, enchantedItem) -> {
            LootContext context = this.contextSupplier.getContext(enchantmentLevel);
            this.componentType.ifLeft(componentType -> {
                for (ConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(componentType)) {
                    if (!effect.matches(context)) continue;
                    acceptor.apply(effect.effect(), (Entity)target, enchantmentLevel);
                }
            });
            this.componentType.ifRight(componentType -> {
                for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(componentType)) {
                    LivingEntity entity;
                    if (!effect.matches(context)) continue;
                    DamageSource source = (DamageSource)context.getParam(LootContextParams.DAMAGE_SOURCE);
                    if ((entity = (switch (effect.affected()) {
                        default -> throw new MatchException(null, null);
                        case EnchantmentTarget.ATTACKER -> source.getEntity();
                        case EnchantmentTarget.DAMAGING_ENTITY -> source.getDirectEntity();
                        case EnchantmentTarget.VICTIM -> target;
                    })) == null) continue;
                    acceptor.apply(effect.effect(), (Entity)entity, enchantmentLevel);
                }
            });
        });
    }

    public static LootContext entityContext(ServerLevel level, int enchantmentLevel, Entity entity, Vec3 origin, @Nullable ItemStack tool) {
        LootParams lootparams = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantmentLevel).withParameter(LootContextParams.ORIGIN, (Object)origin).withOptionalParameter(LootContextParams.TOOL, (Object)tool).create(LootContextParamSets.ENCHANTED_ENTITY);
        return new LootContext.Builder(lootparams).create(Optional.empty());
    }

    public static LootContext damageContext(ServerLevel level, int enchantmentLevel, Entity entity, DamageSource damageSource, @Nullable ItemStack tool) {
        LootParams lootparams = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantmentLevel).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).withOptionalParameter(LootContextParams.TOOL, (Object)tool).create(LootContextParamSets.ENCHANTED_DAMAGE);
        return new LootContext.Builder(lootparams).create(Optional.empty());
    }

    public static interface ContextSupplier {
        public LootContext getContext(int var1);
    }

    public static interface EnchantmentEffectAcceptor<T> {
        default public void apply(T effect, int enchantmentLevel) {
            this.apply(effect, null, enchantmentLevel);
        }

        public void apply(T var1, Entity var2, int var3);
    }
}

