/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.mojang.math.Axis;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MiscTools {
    public static StreamCodec<ByteBuf, Vec3> VEC3_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new);

    public static Level getLevel(MinecraftServer server, GlobalPos globalPos) {
        if (server == null) {
            return null;
        }
        return server.getLevel(globalPos.dimension());
    }

    public static CompoundTag globalPosToNBT(GlobalPos globalPos) {
        CompoundTag tag = new CompoundTag();
        tag.putString("dimension", globalPos.dimension().location().toString());
        tag.put("blockpos", NbtUtils.writeBlockPos((BlockPos)globalPos.pos()));
        return tag;
    }

    public static GlobalPos nbtToGlobalPos(CompoundTag tag) {
        if (!tag.contains("dimension")) {
            return null;
        }
        ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("dimension")));
        BlockPos blockPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"blockpos").orElse(BlockPos.ZERO);
        return blockPos.equals((Object)BlockPos.ZERO) ? null : GlobalPos.of((ResourceKey)levelKey, (BlockPos)blockPos);
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }

    public static Vector3f findOffset(Direction direction, int slot, Vector3f[] offsets) {
        Vector3f offsetVector = new Vector3f((Vector3fc)offsets[slot]);
        switch (direction) {
            case UP: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 1.0f, 0.0f);
                break;
            }
            case DOWN: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
                break;
            }
            case EAST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 0.0f);
                break;
            }
            case SOUTH: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-180.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
            }
        }
        return offsetVector;
    }

    public static ListTag stringListToNBT(List<String> list) {
        ListTag nbtList = new ListTag();
        for (String string : list) {
            CompoundTag tag = new CompoundTag();
            tag.putString("list", string);
            nbtList.add((Object)tag);
        }
        return nbtList;
    }

    public static List<String> NBTToStringList(ListTag nbtList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag tag = nbtList.getCompound(i);
            list.add(tag.getString("list"));
        }
        return list;
    }

    public static MutableComponent tooltipMaker(String string, int color) {
        Style style = Style.EMPTY;
        style = style.withColor(color);
        MutableComponent current = Component.translatable((String)string);
        current.setStyle(style);
        return current;
    }
}

