/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.generator.KubeDataGenerator;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.uncandango.kubejstweaks.kubejs.plugin.KJSTPluginUtils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

@Info(value="Disables an entry at datapack level\n")
public class NoOpEventJS
implements KubeEvent {
    @HideFromJS
    public static final Supplier<JsonObject> NO_OP_CONDITION_OPS = () -> {
        JsonObject json = new JsonObject();
        JsonArray conditions = new JsonArray();
        JsonObject condition = new JsonObject();
        condition.add("type", (JsonElement)new JsonPrimitive("neoforge:false"));
        conditions.add((JsonElement)condition);
        json.add("neoforge:conditions", (JsonElement)conditions);
        return json;
    };
    private static final Supplier<JsonObject> NO_OP_NEOFORGE_NONE = () -> {
        JsonObject json = new JsonObject();
        json.add("type", (JsonElement)new JsonPrimitive("neoforge:none"));
        return json;
    };
    private final KubeDataGenerator generator;

    public NoOpEventJS(KubeDataGenerator generator) {
        this.generator = generator;
    }

    @Info(value="Adds a condition that is always false, which effectively disables it\n")
    public void recipes(ResourceLocation id) {
        id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("recipe/" + id.getPath()));
        JsonObject merged = this.queryAndMergeJson(id, KJSTPluginUtils.KJSTPackType.DATA, NO_OP_CONDITION_OPS.get());
        this.setNoOpForId(id, () -> merged);
    }

    private JsonObject queryAndMergeJson(ResourceLocation id, KJSTPluginUtils.KJSTPackType kjstPackType, JsonObject noOpJson) {
        JsonElement originalJson = KJSTPluginUtils.readJsonFromMod(KubeJS.getStartupScriptManager().contextFactory.enter(), id.getNamespace(), id.toString(), kjstPackType);
        if (originalJson instanceof JsonObject) {
            JsonObject obj = (JsonObject)originalJson;
            NoOpEventJS.mergeJson(obj, noOpJson);
            return obj;
        }
        return noOpJson;
    }

    @Info(value="Adds a condition that is always false, which effectively disables it\n")
    public void lootTables(ResourceLocation id) {
        id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("loot_table/" + id.getPath()));
        JsonObject merged = this.queryAndMergeJson(id, KJSTPluginUtils.KJSTPackType.DATA, NO_OP_CONDITION_OPS.get());
        this.setNoOpForId(id, () -> merged);
    }

    @Info(value="Adds a condition that is always false, which effectively disables it\n")
    public void lootTablesBlock(ResourceLocation id) {
        id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("loot_table/blocks/" + id.getPath()));
        JsonObject merged = this.queryAndMergeJson(id, KJSTPluginUtils.KJSTPackType.DATA, NO_OP_CONDITION_OPS.get());
        this.setNoOpForId(id, () -> merged);
    }

    @Info(value="Adds a no-op type, disabling the biome modifier\n")
    public void biomeModifiers(ResourceLocation id) {
        id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("neoforge/biome_modifier/" + id.getPath()));
        JsonObject merged = this.queryAndMergeJson(id, KJSTPluginUtils.KJSTPackType.DATA, NO_OP_NEOFORGE_NONE.get());
        this.setNoOpForId(id, () -> merged);
    }

    @Info(value="This is effectively the same event as generateData with \"last\" argument.\nUse it to add any kind of json you wish\n")
    public void json(ResourceLocation id, JsonElement json) {
        this.generator.add(GeneratedData.json((ResourceLocation)id, () -> json));
    }

    @HideFromJS
    public static void mergeJson(JsonObject first, JsonObject second) {
        Map map = second.asMap();
        map.forEach((arg_0, arg_1) -> ((JsonObject)first).add(arg_0, arg_1));
    }

    private void setNoOpForId(ResourceLocation id, Supplier<JsonElement> json) {
        this.generator.add(GeneratedData.json((ResourceLocation)id, json));
    }
}

