/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.utils;

import com.devdyna.justdynathings.datagen.client.DataBlockModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class DataGenUtil {
    public static final ResourceLocation CUTOUT = ResourceLocation.withDefaultNamespace((String)"cutout");
    private static String mc = "minecraft:";
    public static String TOOL = mc + "item/handheld";
    public static String ITEM = mc + "item/generated";
    private static String mod = "justdynathings:";
    public static String CUBE_ALL = "block/cube_all";

    public static Block getModBlock(String id) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"justdynathings", (String)id));
    }

    public static Block getBlock(String modid, String id) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modid, (String)id));
    }

    public static String getPath(Block b) {
        return BuiltInRegistries.BLOCK.getKey((Object)b).getPath();
    }

    public static String getPath(Fluid b) {
        return BuiltInRegistries.FLUID.getKey((Object)b).getPath();
    }

    public static String getPath(Item i) {
        return BuiltInRegistries.ITEM.getKey((Object)i).getPath();
    }

    public static ResourceLocation getResource(String s, String modid) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)s);
    }

    public static ResourceLocation getResource(Block b, String modid) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)DataGenUtil.getPath(b));
    }

    public static ResourceLocation getResource(Item i, String modid) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)DataGenUtil.getPath(i));
    }

    public static ResourceLocation getResource(String s) {
        return DataGenUtil.getResource(s, "justdynathings");
    }

    public static ResourceLocation getResource(Block b) {
        return DataGenUtil.getResource(b, "justdynathings");
    }

    public static ResourceLocation getResource(Item i) {
        return DataGenUtil.getResource(i, "justdynathings");
    }

    @Deprecated
    public static ItemModelBuilder itemTool(Item item, ItemModelProvider b) {
        return b.handheldItem(item);
    }

    public static ItemModelBuilder itemModel(Item item, ItemModelProvider b) {
        return (ItemModelBuilder)((ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(item), ITEM)).texture("layer0", DataGenUtil.getResource("item/" + DataGenUtil.getPath(item)));
    }

    public static ItemModelBuilder itemBlock(Block block, ItemModelProvider b) {
        return (ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(block), mod + "block/" + DataGenUtil.getPath(block));
    }

    public static ItemModelBuilder itemBlockwithParent(Block block, ItemModelProvider b, String parent) {
        return (ItemModelBuilder)b.withExistingParent(DataGenUtil.getPath(block), parent);
    }

    public static ItemModelBuilder itemBlockwithParent(Block block, ItemModelProvider b, String parent, String keyname, String texture) {
        return (ItemModelBuilder)DataGenUtil.itemBlockwithParent(block, b, parent).texture(keyname, texture);
    }

    public static BlockModelBuilder BlockwithParent(Block block, BlockStateProvider b, String parent, String keyname, String texture) {
        return (BlockModelBuilder)((BlockModelBuilder)b.models().withExistingParent(DataGenUtil.getPath(block), parent)).texture(keyname, texture);
    }

    public static BlockModelBuilder BlockwithParent(Block block, BlockStateProvider b, String parent) {
        return (BlockModelBuilder)b.models().withExistingParent(DataGenUtil.getPath(block), parent);
    }

    public static void MonoStateBlock(DataBlockModelState d, Block b, String parent) {
        d.simpleBlock(b, (ModelFile)DataGenUtil.BlockwithParent(b, d, parent));
    }

    public static void MonoStateBlock(DataBlockModelState d, Block b, String parent, String keyname, String texture) {
        d.simpleBlock(b, (ModelFile)DataGenUtil.BlockwithParent(b, d, parent).texture(keyname, texture));
    }

    public static String getName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public static String getName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public static void BiStateBlock(DataBlockModelState t, Block b, BooleanProperty p, ResourceLocation on, ResourceLocation off) {
        ((VariantBlockStateBuilder)t.getVariantBuilder(b).partialState().with((Property)p, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)t.models().getExistingFile(on)).addModel()).partialState().with((Property)p, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)t.models().getExistingFile(off)).addModel();
    }

    public static void BiStateBlock(DataBlockModelState t, Block b, BooleanProperty p, ModelFile on, ModelFile off) {
        ((VariantBlockStateBuilder)t.getVariantBuilder(b).partialState().with((Property)p, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).addModel()).partialState().with((Property)p, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).addModel();
    }

    public static void BiStateBlock(DataBlockModelState t, Block b, BooleanProperty p, ModelFile on, ResourceLocation off) {
        ((VariantBlockStateBuilder)t.getVariantBuilder(b).partialState().with((Property)p, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(on).addModel()).partialState().with((Property)p, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)t.models().getExistingFile(off)).addModel();
    }

    public static void BiStateBlock(DataBlockModelState t, Block b, BooleanProperty p, ResourceLocation on, ModelFile off) {
        ((VariantBlockStateBuilder)t.getVariantBuilder(b).partialState().with((Property)p, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)t.models().getExistingFile(on)).addModel()).partialState().with((Property)p, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(off).addModel();
    }

    public static void SimpleBlock(Block block, String modid, DataBlockModelState t) {
        t.simpleBlock(block, (ModelFile)t.models().getExistingFile(DataGenUtil.getResource("block/" + DataGenUtil.getName(block), modid)));
    }

    public static void SimpleBlock(Block block, DataBlockModelState t) {
        DataGenUtil.SimpleBlock(block, "justdynathings", t);
    }

    public static BlockModelBuilder cutOut(BlockModelBuilder b) {
        return (BlockModelBuilder)b.renderType(CUTOUT);
    }

    public static BlockModelBuilder NamewithParent(String name, BlockStateProvider b, String parent) {
        return (BlockModelBuilder)b.models().withExistingParent(name, parent);
    }

    public static BlockModelBuilder NamewithParent(String name, BlockStateProvider b, String parent, String keyname, String texture) {
        return (BlockModelBuilder)((BlockModelBuilder)b.models().withExistingParent(name, parent)).texture(keyname, texture);
    }

    public static BlockModelBuilder CubeAll(String name, BlockStateProvider b, String texture) {
        return (BlockModelBuilder)((BlockModelBuilder)b.models().withExistingParent(name, CUBE_ALL)).texture("all", texture);
    }

    public static ICondition[] isModLoaded(String modid) {
        return new ICondition[]{new ModLoadedCondition(modid)};
    }

    public static String txtDecor(String name) {
        StringBuilder result = new StringBuilder();
        for (String word : name.replaceAll("_", " ").split(" ")) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public static String getMod(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace();
    }

    public static String getMod(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    public static String getFullName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace() + ":" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public static String getFullName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace() + ":" + BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }
}

