/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.functional_anvils;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.builders.functional_anvils.CAnvilBE;
import com.devdyna.justdynathings.registry.interfaces.block.BucketInteractive;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CAnvilBlock
extends BaseMachineBlock
implements BucketInteractive {
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape X_LEG1 = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape X_LEG2 = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape X_TOP = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape Z_LEG1 = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape Z_LEG2 = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape Z_TOP = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{X_LEG1, X_LEG2, X_TOP});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Z_LEG1, Z_LEG2, Z_TOP});

    public CAnvilBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(4.0f).destroyTime(4.0f).isRedstoneConductor(BaseMachineBlock::never).sound(SoundType.ANVIL).pushReaction(PushReaction.BLOCK));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new CAnvilBE(p, s);
    }

    public void openMenu(Player p, BlockPos b) {
    }

    public boolean isValidBE(BlockEntity b) {
        return b instanceof CAnvilBE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)this.defaultBlockState().setValue((Property)AnvilBlock.FACING, (Comparable)c.getHorizontalDirection().getClockWise());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{AnvilBlock.FACING});
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return ((Direction)s.getValue((Property)AnvilBlock.FACING)).getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Constants.ModAddonCheck.docCheck && !common.DOC_WARNING.getAsBoolean()) {
            tooltipComponents.add((Component)Component.translatable((String)"justdynathings.doc.missing"));
        }
    }

    public BlockState direRotate(BlockState s, Rotation r) {
        return (BlockState)s.cycle((Property)AnvilBlock.FACING);
    }

    public BlockState direRotate(BlockState s, LevelAccessor l, BlockPos p, Rotation d) {
        return (BlockState)s.cycle((Property)AnvilBlock.FACING);
    }

    public BlockState rotate(BlockState s, Rotation r) {
        return (BlockState)s.cycle((Property)AnvilBlock.FACING);
    }

    public abstract boolean supportFluidContent();

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.supportFluidContent()) {
            return this.bucketAction(stack, state, level, pos, player, hand, hitResult);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

