/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.budding;

import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.interfaces.be.FluidMachine;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.DirectionUtil;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blocks.resources.TimeCrystalCluster;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BuddingBE
extends BaseMachineBE
implements EnergyMachine,
FluidMachine {
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);
    public final FluidContainerData fluidContainerData = new FluidContainerData((FluidMachineBE)this);
    public Block smallCluster;
    public Block mediumCluster;
    public Block largeCluster;
    public Block finalCluster;

    public BuddingBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tickServer() {
        Direction dir;
        this.updateBlock();
        if (LevelUtil.chance(25, this.level) && ((Boolean)this.getBlockState().getValue((Property)zProperties.GOO_ALIVE)).booleanValue() && this.growCluster(dir = DirectionUtil.randomDirection(this.level, Direction.values()))) {
            if (((Boolean)common.BUDDING_GENERAL_SOUND.get()).booleanValue()) {
                this.applySound(dir);
            }
            if (!((Boolean)common.BUDDING_GENERAL_FE_CHANCE.get()).booleanValue() || LevelUtil.rnd50(this.level)) {
                this.extractFEWhenPossible();
            }
            if (!((Boolean)common.BUDDING_GENERAL_MB_CHANCE.get()).booleanValue() || LevelUtil.rnd50(this.level)) {
                this.extractMBWhenPossible();
            }
        }
    }

    public boolean growCluster(Direction dir) {
        Block block;
        BlockState state = this.level.getBlockState(this.getBlockPos().relative(dir));
        Object object = BuddingAmethystBlock.canClusterGrowAtState((BlockState)state) ? this.smallCluster : (state.is(this.smallCluster) && state.getValue((Property)AmethystClusterBlock.FACING) == dir ? this.mediumCluster : (state.is(this.mediumCluster) && state.getValue((Property)AmethystClusterBlock.FACING) == dir ? this.largeCluster : (block = state.is(this.largeCluster) && state.getValue((Property)AmethystClusterBlock.FACING) == dir ? this.finalCluster : null)));
        if (block != null) {
            this.level.setBlockAndUpdate(this.getBlockPos().relative(dir), (BlockState)((BlockState)block.defaultBlockState().setValue((Property)TimeCrystalCluster.FACING, (Comparable)dir)).setValue((Property)TimeCrystalCluster.WATERLOGGED, (Comparable)Boolean.valueOf(state.getFluidState().getType() == Fluids.WATER)));
            return true;
        }
        return false;
    }

    public void applySound(Direction dir) {
        if (LevelUtil.chance(50, this.level)) {
            this.level.playSound(null, this.getBlockPos().relative(dir), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 1.0f, 0.25f);
        }
    }

    public void updateBlock() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.GOO_ALIVE, (Comparable)Boolean.valueOf(this.canExtractFE() && this.canExtractMB())));
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.getData(Registration.PARADOX_FLUID_HANDLER);
    }

    @Override
    public int getMaxMB() {
        return (Integer)common.BUDDING_GENERAL_MB_CAPACITY.get();
    }

    @Override
    public int getStandardFluidCost() {
        return (Integer)common.BUDDING_GENERAL_MB_COST.get();
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)common.BUDDING_GENERAL_FE_COST.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)common.BUDDING_GENERAL_FE_CAPACITY.get();
    }
}

