/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.recipes;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class RecipeSorter
extends SimplePreparableReloadListener<Void> {
    public static final RecipeSorter INSTANCE = new RecipeSorter();
    private int currentGeneration = 0;
    private int lastKnownGeneration = -1;
    private Map<Item, List<JumboFurnaceRecipe>> cachedSortedRecipes = new Reference2ObjectOpenHashMap();
    private List<JumboFurnaceRecipe> allRecipes = new ArrayList<JumboFurnaceRecipe>();

    public SortedSet<JumboFurnaceRecipe> getSortedFurnaceRecipesValidForInputs(Collection<Item> inputItems, RecipeManager manager) {
        if (this.currentGeneration != this.lastKnownGeneration) {
            this.sortFurnaceRecipes(manager);
            this.lastKnownGeneration = this.currentGeneration;
        }
        ObjectRBTreeSet recipesForItems = new ObjectRBTreeSet(RecipeSorter::compareRecipes);
        for (Item item : inputItems) {
            List<JumboFurnaceRecipe> recipesForItem = this.cachedSortedRecipes.get(item);
            if (recipesForItem == null) continue;
            recipesForItems.addAll(recipesForItem);
        }
        return recipesForItems;
    }

    public List<JumboFurnaceRecipe> getAllSortedFurnaceRecipes(RecipeManager manager) {
        if (this.currentGeneration != this.lastKnownGeneration) {
            this.sortFurnaceRecipes(manager);
            this.lastKnownGeneration = this.currentGeneration;
        }
        return this.allRecipes;
    }

    private void sortFurnaceRecipes(RecipeManager manager) {
        Reference2ObjectOpenHashMap results = new Reference2ObjectOpenHashMap();
        ObjectRBTreeSet allRecipes = new ObjectRBTreeSet(RecipeSorter::compareRecipes);
        HashMap<ResourceLocation, JumboFurnaceRecipe> wrappedRecipes = new HashMap<ResourceLocation, JumboFurnaceRecipe>();
        for (RecipeHolder holder : manager.getAllRecipesFor(RecipeType.SMELTING)) {
            ResourceLocation key = holder.id();
            JumboFurnaceRecipe recipe = new JumboFurnaceRecipe((SmeltingRecipe)holder.value());
            allRecipes.add(recipe);
            for (Ingredient ingredient : recipe.getIngredients()) {
                ItemStack[] itemStackArray = ingredient.getItems();
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack stack = itemStackArray[i];
                    results.computeIfAbsent(stack.getItem(), x -> new ArrayList()).add(wrappedRecipes.computeIfAbsent(key, x -> recipe));
                }
            }
        }
        for (RecipeHolder holder : manager.getAllRecipesFor((RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get())) {
            JumboFurnaceRecipe recipe = (JumboFurnaceRecipe)holder.value();
            allRecipes.add(recipe);
            for (Ingredient ingredient : recipe.getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    results.computeIfAbsent(stack.getItem(), x -> new ArrayList()).add(recipe);
                }
            }
        }
        this.cachedSortedRecipes = results;
        this.allRecipes = allRecipes.stream().toList();
    }

    public static int compareRecipes(JumboFurnaceRecipe a, JumboFurnaceRecipe b) {
        return b.specificity().get() - a.specificity().get();
    }

    protected Void prepare(ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        return null;
    }

    protected void apply(Void objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ++this.currentGeneration;
    }
}

