/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.jumbo_furnace;

import java.util.Optional;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.JumboFurnaceUtils;
import net.commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreBlockEntity;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceFuelSlot;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import net.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceSyncData;
import net.commoble.jumbofurnace.jumbo_furnace.MultiprocessUpgradeHandler;
import net.commoble.jumbofurnace.jumbo_furnace.UninsertableItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class JumboFurnaceMenu
extends AbstractContainerMenu {
    public static final String TITLE = "container.jumbofurnace.jumbo_furnace";
    public static final int SLOT_SPACING = 18;
    public static final int INPUT_START_X = 8;
    public static final int INPUT_START_Y = 18;
    public static final int FUEL_START_X = 8;
    public static final int FUEL_START_Y = 90;
    public static final int OUTPUT_START_X = 116;
    public static final int OUTPUT_START_Y = 53;
    public static final int BACKPACK_START_X = 8;
    public static final int BACKPACK_START_Y = 158;
    public static final int HOTBAR_START_X = 8;
    public static final int HOTBAR_START_Y = 216;
    public static final int ORTHOFURNACE_SLOT_X = 134;
    public static final int ORTHOFURNACE_SLOT_Y = 117;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLUMNS = 3;
    public static final int BACKPACK_ROWS = 3;
    public static final int PLAYER_COLUMNS = 9;
    public static final int INPUT_SLOTS = 9;
    public static final int BACKPACK_SLOTS = 27;
    public static final int HOTBAR_SLOTS = 9;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_FUEL_SLOT = 9;
    public static final int FIRST_OUTPUT_SLOT = 18;
    public static final int ORTHOFURNACE_SLOT = 27;
    public static final int FIRST_HOTBAR_SLOT = 28;
    public static final int FIRST_BACKPACK_SLOT = 37;
    public static final int FIRST_PLAYER_SLOT = 28;
    public static final int END_INPUT_SLOTS = 9;
    public static final int END_FUEL_SLOTS = 18;
    public static final int END_PLAYER_SLOTS = 64;
    private final ContainerLevelAccess usabilityTest;
    private final ContainerData furnaceData;
    private final Optional<JumboFurnaceCoreBlockEntity> serverFurnace;

    public static JumboFurnaceMenu getClientMenu(int id, Inventory playerInventory) {
        return new JumboFurnaceMenu(id, playerInventory, BlockPos.ZERO, (IItemHandler)new ItemStackHandler(9), (IItemHandler)new ItemStackHandler(9), (IItemHandler)new UninsertableItemStackHandler(9), (IItemHandler)new ItemStackHandler(1), (ContainerData)new SimpleContainerData(4), Optional.empty());
    }

    public static MenuProvider getServerMenuProvider(JumboFurnaceCoreBlockEntity te, BlockPos activationPos) {
        return new SimpleMenuProvider((id, playerInventory, serverPlayer) -> new JumboFurnaceMenu(id, playerInventory, activationPos, (IItemHandler)te.input, (IItemHandler)te.fuel, (IItemHandler)te.output, (IItemHandler)te.multiprocessUpgradeHandler, new JumboFurnaceSyncData(te), Optional.of(te)), (Component)Component.translatable((String)TITLE));
    }

    protected JumboFurnaceMenu(int id, Inventory playerInventory, BlockPos pos, IItemHandler inputs, IItemHandler fuel, IItemHandler outputs, IItemHandler multiprocessUpgrades, ContainerData furnaceData, Optional<JumboFurnaceCoreBlockEntity> serverFurnace) {
        super((MenuType)JumboFurnace.get().jumboFurnaceMenuType.get(), id);
        int index;
        int x;
        int column;
        int y;
        int row;
        Player player = playerInventory.player;
        this.usabilityTest = ContainerLevelAccess.create((Level)player.level(), (BlockPos)pos);
        this.furnaceData = furnaceData;
        this.serverFurnace = serverFurnace;
        for (row = 0; row < 3; ++row) {
            y = 18 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.addSlot((Slot)new SlotItemHandler(inputs, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 90 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.addSlot((Slot)new JumboFurnaceFuelSlot(fuel, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 53 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 116 + 18 * column;
                index = row * 3 + column;
                this.addSlot((Slot)new JumboFurnaceOutputSlot(player, outputs, index, x, y));
            }
        }
        this.addSlot((Slot)new MultiprocessUpgradeHandler.MultiprocessUpgradeSlotHandler(multiprocessUpgrades, 0, 134, 117));
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x2 = 8 + 18 * hotbarSlot;
            this.addSlot(new Slot((Container)playerInventory, hotbarSlot, x2, 216));
        }
        for (row = 0; row < 3; ++row) {
            y = 158 + 18 * row;
            for (column = 0; column < 9; ++column) {
                x = 8 + 18 * column;
                index = row * 9 + column + 9;
                this.addSlot(new Slot((Container)playerInventory, index, x, y));
            }
        }
        this.addDataSlots(furnaceData);
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack finalUpgradeStack = this.getSlot(27).getItem();
            ((UpgradeJumboFurnaceTrigger)((Object)JumboFurnace.get().upgradeJumboFurnaceTrigger.get())).test(serverPlayer, finalUpgradeStack);
        }
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        return JumboFurnaceMenu.stillValid((ContainerLevelAccess)this.usabilityTest, (Player)player, (Block)((Block)JumboFurnace.get().jumboFurnaceBlock.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            slotStackCopy = stackInSlot.copy();
            if (index < 28) {
                if (!this.moveItemStackTo(stackInSlot, 28, 64, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (stackInSlot.is(JumboFurnace.MULTIPROCESSING_UPGRADE_TAG)) {
                    if (this.moveItemStackTo(stackInSlot, 27, 28, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markInputInventoryChanged);
                    } else {
                        return ItemStack.EMPTY;
                    }
                }
                if (JumboFurnaceUtils.getJumboSmeltingBurnTime(stackInSlot) > 0) {
                    if (this.moveItemStackTo(stackInSlot, 9, 18, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markFuelInventoryChanged);
                    } else {
                        return ItemStack.EMPTY;
                    }
                }
                if (this.moveItemStackTo(stackInSlot, 0, 9, false)) {
                    this.serverFurnace.ifPresent(JumboFurnaceCoreBlockEntity::markInputInventoryChanged);
                } else {
                    return ItemStack.EMPTY;
                }
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return slotStackCopy;
    }

    public int getBurnTimeRemaining() {
        return this.furnaceData.get(0);
    }

    public int getItemBurnedValue() {
        return this.furnaceData.get(1);
    }

    public int getCurrentRecipeCount() {
        return this.furnaceData.get(2);
    }

    public int getBurnLeftScaled() {
        int totalBurnTime = this.getItemBurnedValue();
        if (totalBurnTime == 0) {
            totalBurnTime = 200;
        }
        return this.getBurnTimeRemaining() * 13 / totalBurnTime;
    }

    public boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }
}

