/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.util.SpellCastUtil;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class SpellTriggerAffix
extends Affix {
    private static final ThreadLocal<Boolean> IS_TRIGGERING = ThreadLocal.withInitial(() -> false);
    public static final Codec<SpellTriggerAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)SpellRegistry.REGISTRY.holderByNameCodec().fieldOf("spell").forGetter(a -> a.spell), (App)TriggerType.CODEC.fieldOf("trigger").forGetter(a -> a.trigger), (App)LootRarity.mapCodec(TriggerData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)TargetType.CODEC.optionalFieldOf("target").forGetter(a -> a.target)).apply((Applicative)inst, SpellTriggerAffix::new));
    protected final Holder<AbstractSpell> spell;
    protected final TriggerType trigger;
    protected final Map<LootRarity, TriggerData> values;
    protected final Set<LootCategory> types;
    protected final Optional<TargetType> target;

    public static boolean isCurrentlyTriggering() {
        return IS_TRIGGERING.get();
    }

    public SpellTriggerAffix(AffixDefinition definition, Holder<AbstractSpell> spell, TriggerType trigger, Map<LootRarity, TriggerData> values, Set<LootCategory> types, Optional<TargetType> target) {
        super(definition);
        this.spell = spell;
        this.trigger = trigger;
        this.values = values;
        this.types = types;
        this.target = target;
    }

    public void triggerSpell(LivingEntity caster, LivingEntity target, AffixInstance inst) {
        this.triggerSpell(caster, target, (LootRarity)inst.rarity().get(), inst.level());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSpell(LivingEntity caster, LivingEntity target, LootRarity rarity, float level) {
        if (IS_TRIGGERING.get().booleanValue()) {
            return;
        }
        TriggerData data = this.values.get(rarity);
        if (data == null || caster.level().isClientSide()) {
            return;
        }
        int spellLevel = data.level().getInt(level);
        AbstractSpell spellInstance = (AbstractSpell)this.spell.value();
        String spellId = spellInstance.getSpellId();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        boolean hasActiveRecast = magicData.getPlayerRecasts().hasRecastForSpell(spellId);
        int cooldown = data.cooldown();
        if (!hasActiveRecast && cooldown != 0 && Affix.isOnCooldown((ResourceLocation)this.id(), (int)cooldown, (LivingEntity)caster)) {
            return;
        }
        try {
            IS_TRIGGERING.set(true);
            SpellCastUtil.castSpell(caster, spellInstance, spellLevel, target);
            if (!hasActiveRecast && cooldown != 0) {
                Affix.startCooldown((ResourceLocation)this.id(), (LivingEntity)caster);
            }
        }
        finally {
            IS_TRIGGERING.set(false);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        TriggerData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        String triggerKey = "affix.irons_apothic.trigger." + this.trigger.name().toLowerCase();
        AbstractSpell spellInstance = (AbstractSpell)this.spell.value();
        int spellLevel = data.level().getInt(inst.level());
        MutableComponent coloredSpellName = spellInstance.getDisplayName(null).copy().append(" ").append((Component)Component.translatable((String)("enchantment.level." + spellLevel))).withStyle(spellInstance.getSchoolType().getDisplayName().getStyle());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        String finalKey = isSelfCast ? triggerKey + ".self" : triggerKey;
        MutableComponent comp = Component.translatable((String)finalKey, (Object[])new Object[]{coloredSpellName});
        int cooldown = data.cooldown();
        if (cooldown != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        return comp;
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        int cooldown;
        int maxLevel;
        TriggerData data = this.values.get(inst.rarity().get());
        if (data == null) {
            return Component.empty();
        }
        int currentLevel = data.level().getInt(inst.level());
        AbstractSpell spellInstance = (AbstractSpell)this.spell.value();
        MutableComponent coloredSpellName = spellInstance.getDisplayName(null).copy().append(" ").append((Component)Component.translatable((String)("enchantment.level." + currentLevel))).withStyle(spellInstance.getSchoolType().getDisplayName().getStyle());
        boolean isSelfCast = this.target.map(t -> t == TargetType.SELF).orElse(false);
        String triggerKey = "affix.irons_apothic.trigger." + this.trigger.name().toLowerCase();
        String finalKey = isSelfCast ? triggerKey + ".self" : triggerKey;
        MutableComponent comp = Component.translatable((String)finalKey, (Object[])new Object[]{coloredSpellName});
        int minLevel = data.level().getInt(0.0f);
        if (minLevel != (maxLevel = data.level().getInt(1.0f))) {
            MutableComponent minComp = Component.translatable((String)("enchantment.level." + minLevel));
            MutableComponent maxComp = Component.translatable((String)("enchantment.level." + maxLevel));
            comp.append((Component)Affix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((cooldown = data.cooldown()) != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        return comp;
    }

    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
        if (this.trigger == TriggerType.MELEE_HIT && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            LivingEntity actualTarget = this.target.map(targetType -> switch (targetType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> user;
                case 1 -> livingTarget;
            }).orElse(livingTarget);
            this.triggerSpell(user, actualTarget, inst);
        }
    }

    public void doPostHurt(AffixInstance inst, LivingEntity user, DamageSource source) {
        Entity entity;
        if (this.trigger == TriggerType.HURT && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity actualTarget = this.target.map(targetType -> switch (targetType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> user;
                case 1 -> attacker;
            }).orElse(user);
            this.triggerSpell(user, actualTarget, inst);
        }
    }

    public void onProjectileImpact(float level, LootRarity rarity, Projectile proj, HitResult res, HitResult.Type type) {
        EntityHitResult entityHit;
        Entity entity;
        if (this.trigger == TriggerType.PROJECTILE_HIT && type == HitResult.Type.ENTITY && res instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)res).getEntity()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            entity = proj.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                LivingEntity actualTarget = this.target.map(targetType -> switch (targetType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> owner;
                    case 1 -> hitEntity;
                }).orElse(hitEntity);
                this.triggerSpell(owner, actualTarget, rarity, level);
            }
        }
    }

    public static enum TriggerType {
        SPELL_DAMAGE,
        SPELL_HEAL,
        MELEE_HIT,
        PROJECTILE_HIT,
        HURT;

        public static final Codec<TriggerType> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(TriggerType.class);
        }
    }

    public record TriggerData(StepFunction level, int cooldown) {
        private static final Codec<TriggerData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.optionalFieldOf("level", (Object)StepFunction.constant((float)1.0f)).forGetter(TriggerData::level), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(TriggerData::cooldown)).apply((Applicative)inst, TriggerData::new));
    }

    public static enum TargetType {
        SELF,
        TARGET;

        public static final Codec<TargetType> CODEC;

        static {
            CODEC = PlaceboCodecs.enumCodec(TargetType.class);
        }
    }
}

