/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.compat.irons_spellbooks;

import com.sammy.malum.visual_effects.ScreenParticleEffects;
import com.strawberry.gaze.client.screens.codex.screens.GazeProgressionScreen;
import com.strawberry.gaze.compat.irons_spellbooks.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import top.theillusivec4.curios.api.SlotContext;

public class EncyclopediaSpellBook
extends UniqueSpellBook
implements ParticleEmitterHandler.ItemParticleSupplier {
    public EncyclopediaSpellBook(Item.Properties properties) {
        super(SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.SOULWARD_SHIELD, 1)}), 10);
        this.withSpellbookAttributes(new AttributeContainer[]{new AttributeContainer((Holder)AttributeRegistry.SPELL_POWER, -0.08, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.ELDRITCH_SPELL_POWER, 0.32, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.ENDER_SPELL_POWER, 0.16, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.MAX_MANA, 320.0, AttributeModifier.Operation.ADD_VALUE)});
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.swing(hand);
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.getConnection() != null) {
                mc.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
            }
            GazeProgressionScreen.getScreen().openCodexViaTransition();
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)itemStack);
        if (!affinityData.affinityData().isEmpty()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.irons_spellbooks.spellbook_spell_count");
            lines.addAll(i < 0 ? lines.size() : i + 1, affinityData.getDescriptionComponent());
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        AffinityData.setAffinityData((ItemStack)itemStack, (AbstractSpell)((AbstractSpell)io.redspace.ironsspellbooks.api.registry.SpellRegistry.ELDRITCH_BLAST_SPELL.get()), (int)3);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        ScreenParticleEffects.spawnVoidItemScreenParticles((ScreenParticleHolder)target, (Level)level, (float)0.2f, (float)partialTick);
    }
}

