/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GazeGreaterEarthenCorruptedRiteEffect
extends SpiritRiteBlockEffect {
    public GazeGreaterEarthenCorruptedRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.GREATER_RITE});
    }

    private AABB getEffectBounds(BlockPos pos, float potency) {
        int range = Math.max(0, (int)potency);
        return new AABB(pos).inflate((double)range);
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState state, BlockPos pos, float potency) {
        List items = level.getEntitiesOfClass(ItemEntity.class, this.getEffectBounds(pos, potency));
        for (ItemEntity itemEntity : items) {
            ItemStack stack = itemEntity.getItem();
            Item item = stack.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            BlockPos itemPos = itemEntity.blockPosition();
            boolean planted = false;
            for (int dx = -1; dx <= 1 && !planted; ++dx) {
                for (int dz = -1; dz <= 1 && !planted; ++dz) {
                    BlockPos groundPos = itemPos.offset(dx, -1, dz);
                    BlockPos placePos = groundPos.above();
                    BlockState groundState = level.getBlockState(groundPos);
                    if (!groundState.isSolidRender((BlockGetter)level, groundPos) || !level.isEmptyBlock(placePos)) continue;
                    level.setBlockAndUpdate(placePos, blockItem.getBlock().defaultBlockState());
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        itemEntity.discard();
                    }
                    planted = true;
                    this.createEffect(level, placePos, new SpiritLike[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT});
                }
            }
        }
    }
}

