/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.mobeffects;

import dev.ftb.mods.ftboceanmobs.FTBOceanMobsTags;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.EffectCures;

public class DrowningShadowsEffect
extends MobEffect {
    public DrowningShadowsEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        livingEntity.hurt(livingEntity.damageSources().magic(), (float)(1 << amplifier));
        boolean cured = livingEntity.getBlockStateOn().is(FTBOceanMobsTags.Blocks.DROWNING_SHADOWS_CURE);
        if (cured && livingEntity.level().isClientSide) {
            livingEntity.playSound(SoundEvents.SPONGE_ABSORB);
            Vec3 vec = livingEntity.getEyePosition().add(livingEntity.getLookAngle().normalize());
            livingEntity.level().addParticle((ParticleOptions)ParticleTypes.HEART, vec.x, vec.y, vec.z, 0.0, 0.01, 0.0);
        }
        return !cured;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        cures.add(EffectCures.PROTECTED_BY_TOTEM);
    }
}

