/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity.riftweaver;

import dev.ftb.mods.ftboceanmobs.Config;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.ChainsEncaser;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverBoss;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverMode;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.SeismicSmasher;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.TidalSurgeRings;
import dev.ftb.mods.ftboceanmobs.registry.ModEntityTypes;
import dev.ftb.mods.ftboceanmobs.registry.ModFluids;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animation.RawAnimation;

public class RiftWeaverModes {
    private static final Map<String, RiftWeaverMode> MODES = new HashMap<String, RiftWeaverMode>();
    public static final RiftWeaverMode HOLD_POSITION = RiftWeaverModes.registerMode(new RiftWeaverMode("hold_position", 0){

        @Override
        public void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            boss.roamTarget = null;
            if (boss.getSpawnPos() != null && boss.getSpawnPos().distToCenterSqr((Position)boss.position()) > 9.0) {
                Vec3 anchor = Vec3.atCenterOf((Vec3i)boss.getSpawnPos());
                boss.getMoveControl().setWantedPosition(anchor.x, anchor.y, anchor.z, 1.5);
            } else if (boss.getRandom().nextInt(300) == 0) {
                boss.switchMode(ROAM);
            }
        }

        @Override
        boolean isIdleMode() {
            return true;
        }

        @Override
        RawAnimation getAnimation() {
            return null;
        }
    });
    public static final RiftWeaverMode ROAM = RiftWeaverModes.registerMode(new RiftWeaverMode("roam", 0){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            if (boss.roamTarget == null || boss.roamTarget.distSqr((Vec3i)boss.blockPosition()) <= 9.0 && boss.getRandom().nextInt(40) == 0) {
                if (boss.getRandom().nextInt(4) == 0) {
                    boss.switchMode(HOLD_POSITION);
                    return;
                }
                float angle = boss.getRandom().nextFloat() * ((float)Math.PI * 2);
                int x = Math.round((float)boss.getSpawnPos().getX() + Mth.sin((float)angle) * (float)(boss.getRandom().nextInt(Config.arenaRadius - 5) + 3));
                int z = Math.round((float)boss.getSpawnPos().getZ() + Mth.cos((float)angle) * (float)(boss.getRandom().nextInt(Config.arenaRadius - 5) + 3));
                int y = boss.level().getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + 1 + boss.getRandom().nextInt(7);
                boss.roamTarget = new BlockPos(x, y, z);
            }
            Vec3 vec = Vec3.atCenterOf((Vec3i)boss.roamTarget);
            if (boss.roamTarget.distToCenterSqr((Position)boss.position()) >= 9.0) {
                boss.getMoveControl().setWantedPosition(vec.x, vec.y, vec.z, 2.5);
            }
        }

        @Override
        boolean isIdleMode() {
            return true;
        }

        @Override
        RawAnimation getAnimation() {
            return null;
        }
    });
    public static final RiftWeaverMode MELEE_SLASH = RiftWeaverModes.registerMode(new RiftWeaverMode("slash", 40){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            LivingEntity tgt = boss.getTarget();
            if (tgt != null && tgt.isAlive() && boss.distanceToSqr((Entity)tgt) > 64.0) {
                boss.getMoveControl().setWantedPosition(tgt.getX(), tgt.getY(), tgt.getZ(), 10.0);
            }
            if (modeTicksRemaining == 5) {
                boss.playSound((SoundEvent)ModSounds.RIFT_DEMON_ATTACK.get());
                for (LivingEntity e : boss.level().getNearbyEntities(LivingEntity.class, RiftWeaverBoss.NOT_RIFT_MOBS, (LivingEntity)boss, new AABB(boss.blockPosition()).inflate(8.0))) {
                    if (!MiscUtil.isLookingAtMe(e, (LivingEntity)boss, 0.9)) continue;
                    boss.doHurtTarget((Entity)e);
                    if (!boss.isFrenzied() || !boss.getRandom().nextBoolean()) continue;
                    e.addEffect(new MobEffectInstance(MobEffects.WITHER, 20 + boss.getRandom().nextInt(40), 2));
                }
            }
        }

        @Override
        void onModeEnd(RiftWeaverBoss boss) {
            boss.nextMeleeSlash = boss.tickCount + (boss.isFrenzied() ? boss.getRandom().nextInt(30) : 20 + boss.getRandom().nextInt(60));
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.SLASH_ANIMATION;
        }
    });
    public static final RiftWeaverMode TIDAL_SURGE = RiftWeaverModes.registerMode(new RiftWeaverMode("surge", 40){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            Level level = boss.level();
            BlockPos origin = level.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR, boss.blockPosition());
            if (modeTicksRemaining == 31) {
                level.playSound(null, origin.above(), SoundEvents.PLAYER_SPLASH_HIGH_SPEED, SoundSource.HOSTILE, 2.0f, 0.5f);
            } else if (modeTicksRemaining <= 30) {
                int radius = 30 - modeTicksRemaining;
                BlockState water = ModFluids.ABYSSAL_WATER_FLOWING.get().getFlowing(7, false).createLegacyBlock();
                TidalSurgeRings.getRingOffsets(radius).forEach(offset -> {
                    BlockPos pos = origin.above(boss.getRandom().nextInt(3) + 2).offset((Vec3i)offset);
                    if (level.getBlockState(pos).isEmpty() && boss.isInArena(pos)) {
                        level.setBlock(pos, water, 3);
                    }
                });
            }
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.SURGE_ANIMATION;
        }
    });
    public static final RiftWeaverMode SEISMIC_SMASH = RiftWeaverModes.registerMode(new RiftWeaverMode("smash", 40){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            LivingEntity e = (LivingEntity)Objects.requireNonNullElse(boss.getTarget(), boss);
            double yGround = boss.level().getHeight(Heightmap.Types.OCEAN_FLOOR, e.getBlockX(), e.getBlockZ());
            boss.getMoveControl().setWantedPosition(e.getX(), yGround + 1.0, e.getZ(), 1.0);
            if (modeTicksRemaining == 10) {
                boss.level().explode((Entity)boss, boss.getX(), boss.getY(), boss.getZ(), 2.0f, Level.ExplosionInteraction.MOB);
                boss.seismicSmasher = new SeismicSmasher(boss.level(), boss.blockPosition(), Config.arenaRadius - 2, 5, boss::isInArena);
            }
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.SMASH_ANIMATION;
        }
    });
    public static final RiftWeaverMode RIFTCLAW_FRENZY = RiftWeaverModes.registerMode(new RiftWeaverMode("frenzy", 80){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            if (modeTicksRemaining == 40) {
                boss.setFrenzied(true);
            }
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.FRENZY_ANIMATION;
        }
    });
    public static final RiftWeaverMode CHAINS = RiftWeaverModes.registerMode(new RiftWeaverMode("chains", 40){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            if (modeTicksRemaining == 20 && boss.getTarget() != null) {
                boss.chainsEncaser = new ChainsEncaser(boss.getTarget(), 40);
            }
        }

        @Override
        void onModeEnd(RiftWeaverBoss boss) {
            boss.nextChainsAttack = boss.tickCount + 200 + boss.getRandom().nextInt(100);
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.CHAINS_ANIMATION;
        }
    });
    public static final RiftWeaverMode REINFORCE = RiftWeaverModes.registerMode(new RiftWeaverMode("reinforce", 40){

        @Override
        void tickMode(RiftWeaverBoss boss, int modeTicksRemaining) {
            if (modeTicksRemaining == 10) {
                this.summonReinforcements(boss);
            }
        }

        @Override
        RawAnimation getAnimation() {
            return RiftWeaverBoss.CHAINS_ANIMATION;
        }

        private void summonReinforcements(RiftWeaverBoss boss) {
            int nPlayers = boss.countPlayersInArena();
            float healthPct = boss.getHealth() / boss.getMaxHealth();
            int healthMod = (int)((1.0f - healthPct) * 5.0f);
            int nMobs = 6 + healthMod + nPlayers - 1;
            RandomSource random = boss.getRandom();
            Level level = boss.level();
            ArrayList<Object> toSpawn = new ArrayList<Object>();
            for (int i = 0; i < nMobs; ++i) {
                toSpawn.add(ModEntityTypes.pickRandomMob(random));
            }
            if (healthPct <= 0.2f) {
                toSpawn.add(ModEntityTypes.RIFT_DEMON.get());
            }
            toSpawn.forEach(entityType -> {
                for (int i = 0; i < 3; ++i) {
                    double angle = random.nextDouble() * Math.PI * 2.0;
                    double dist = 5 + random.nextInt(Config.arenaRadius - 5);
                    double x = (double)boss.getSpawnPos().getX() + Math.cos(angle) * dist;
                    double z = (double)boss.getSpawnPos().getZ() + Math.sin(angle) * dist;
                    BlockPos pos = BlockPos.containing((double)x, (double)boss.getSpawnPos().getY(), (double)z);
                    int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ());
                    BlockPos reinfSpawnPos = new BlockPos(pos.getX(), y + 2, pos.getZ());
                    Vec3 vec = Vec3.atBottomCenterOf((Vec3i)reinfSpawnPos);
                    if (!level.noCollision(entityType.getSpawnAABB(vec.x, vec.y, vec.z)) || entityType.spawn((ServerLevel)level, null, reinfSpawnPos, MobSpawnType.REINFORCEMENT, false, false) == null) continue;
                    level.gameEvent((Entity)boss, (Holder)GameEvent.ENTITY_PLACE, reinfSpawnPos);
                    LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
                    bolt.setPos(vec.x, vec.y, vec.z);
                    bolt.setVisualOnly(true);
                    level.addFreshEntity((Entity)bolt);
                    break;
                }
            });
        }
    });

    public static RiftWeaverMode registerMode(RiftWeaverMode mode) {
        MODES.put(mode.getName(), mode);
        return mode;
    }

    public static Optional<RiftWeaverMode> byName(String name) {
        return Optional.ofNullable(MODES.get(name));
    }

    public static RiftWeaverMode byNameElseHold(String name) {
        return RiftWeaverModes.byName(name).orElse(HOLD_POSITION);
    }

    public static Stream<String> sortedNames() {
        return MODES.keySet().stream().sorted();
    }
}

