/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.DelayedMeleeAttackGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CorrosiveCraig
extends BaseRiftMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final EntityDataAccessor<Boolean> REGEN = SynchedEntityData.defineId(CorrosiveCraig.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FIRE_FIST = SynchedEntityData.defineId(CorrosiveCraig.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final RawAnimation REGEN_ANIMATION = RawAnimation.begin().thenPlay("misc.regeneration");
    private int regenTimer = 0;

    public CorrosiveCraig(EntityType<? extends CorrosiveCraig> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(REGEN, (Object)false);
        builder.define(FIRE_FIST, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.MAX_HEALTH, 120.0).add(Attributes.ARMOR, 15.0).add(Attributes.ARMOR_TOUGHNESS, 10.0).add(Attributes.FOLLOW_RANGE, 36.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 15.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CraigAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public int getCurrentSwingDuration() {
        return 25;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.9);
    }

    public void aiStep() {
        super.aiStep();
        if (this.regenTimer > 0) {
            --this.regenTimer;
        }
        if (this.regenTimer == 30 && this.level().isClientSide) {
            RandomSource rnd = this.getRandom();
            for (int i = 0; i < 50; ++i) {
                Vec3 pos = this.getEyePosition().add(rnd.nextDouble() - 0.5, rnd.nextDouble() + 0.5, rnd.nextDouble() - 0.5);
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.2f, (float)1.0f, (float)0.2f), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 10, this::walkIdleRegenState));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE));
    }

    private PlayState walkIdleRegenState(AnimationState<CorrosiveCraig> state) {
        if (this.regenTimer == 0) {
            if (state.isMoving()) {
                state.setAnimation(DefaultAnimations.WALK);
                state.setControllerSpeed(0.57f);
            } else {
                state.setAnimation(DefaultAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }
        return state.setAndContinue(REGEN_ANIMATION);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (REGEN.equals(key) && this.isRegenActive()) {
            this.regenTimer = 50;
        }
    }

    public boolean isRegenActive() {
        return (Boolean)this.entityData.get(REGEN);
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        float prevHealth = this.getHealth() + damageContainer.getNewDamage();
        if (prevHealth >= this.getMaxHealth() / 2.0f && this.getHealth() < this.getMaxHealth() / 2.0f) {
            this.stopInPlace();
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 2));
            this.entityData.set(REGEN, (Object)true);
        } else {
            this.entityData.set(REGEN, (Object)false);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (((Boolean)this.entityData.get(FIRE_FIST)).booleanValue()) {
                entity.igniteForTicks(40 + entity.getRandom().nextInt(40));
            }
            return true;
        }
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 1.2f, 0.75f);
    }

    @Override
    public void playDelayedAttackSound() {
        this.playSound((SoundEvent)ModSounds.CORROSIVE_CRAIG_ATTACK.get(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.CORROSIVE_CRAIG_DEATH.get();
    }

    protected float nextStep() {
        return this.moveDist + 0.55f;
    }

    class CraigAttackGoal
    extends DelayedMeleeAttackGoal {
        public CraigAttackGoal(CorrosiveCraig mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen, 20);
        }

        public boolean canUse() {
            return CorrosiveCraig.this.regenTimer == 0 && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return CorrosiveCraig.this.regenTimer == 0 && super.canContinueToUse();
        }

        public void stop() {
            super.stop();
            CorrosiveCraig.this.entityData.set(FIRE_FIST, (Object)false);
        }

        @Override
        public void tick() {
            super.tick();
            if (this.mob.getRandom().nextInt(30) == 0) {
                CorrosiveCraig.this.entityData.set(FIRE_FIST, (Object)((Boolean)CorrosiveCraig.this.entityData.get(FIRE_FIST) == false ? 1 : 0));
            }
        }
    }
}

