/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;

public abstract class BaseRiftMob
extends Monster
implements GeoEntity {
    protected BaseRiftMob(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new RiftMobMoveControl(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public void playDelayedAttackSound() {
    }

    static class RiftMobMoveControl
    extends MoveControl {
        private final BaseRiftMob baseRiftMob;

        public RiftMobMoveControl(BaseRiftMob baseRiftMob) {
            super((Mob)baseRiftMob);
            this.baseRiftMob = baseRiftMob;
        }

        public void tick() {
            if (this.baseRiftMob.isInWater()) {
                if (this.operation == MoveControl.Operation.MOVE_TO && !this.baseRiftMob.getNavigation().isDone()) {
                    Vec3 vec3 = new Vec3(this.wantedX - this.baseRiftMob.getX(), this.wantedY - this.baseRiftMob.getY(), this.wantedZ - this.baseRiftMob.getZ());
                    double yOff = vec3.y;
                    float yRot = (float)(Mth.atan2((double)vec3.z, (double)vec3.x) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.baseRiftMob.setYRot(this.rotlerp(this.baseRiftMob.getYRot(), yRot, 90.0f));
                    this.baseRiftMob.yBodyRot = this.baseRiftMob.getYRot();
                    float baseSpeed = (float)(this.speedModifier * this.baseRiftMob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    float speed = Mth.lerp((float)0.125f, (float)this.baseRiftMob.getSpeed(), (float)baseSpeed);
                    this.baseRiftMob.setSpeed(speed);
                    double moveX = Math.cos(this.baseRiftMob.getYRot() * ((float)Math.PI / 180));
                    double moveZ = Math.sin(this.baseRiftMob.getYRot() * ((float)Math.PI / 180));
                    double hBob = Math.sin((double)(this.baseRiftMob.tickCount + this.baseRiftMob.getId()) * 0.5) * 0.05;
                    double vBob = Math.sin((double)(this.baseRiftMob.tickCount + this.baseRiftMob.getId()) * 0.75) * 0.05;
                    this.baseRiftMob.setDeltaMovement(this.baseRiftMob.getDeltaMovement().add(hBob * moveX, vBob * (moveZ + moveX) * 0.35 + (double)speed * yOff * 0.25, hBob * moveZ));
                }
            } else {
                super.tick();
            }
        }
    }
}

