/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.ftb.mods.ftboceanmobs.client.model.RiftMinotaurModel;
import dev.ftb.mods.ftboceanmobs.entity.RiftMinotaur;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RiftMinotaurRenderer
extends GeoEntityRenderer<RiftMinotaur> {
    private static final String LEFT_HAND = "bone8";
    private static final String RIGHT_HAND = "bone13";
    private ItemStack mainHandItem;
    private ItemStack offhandItem;

    public RiftMinotaurRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new RiftMinotaurModel());
        this.addRenderLayer((GeoRenderLayer)new MinotaurHeldLayer());
    }

    public static RiftMinotaurRenderer scaled(EntityRendererProvider.Context renderManager, float scale) {
        return (RiftMinotaurRenderer)new RiftMinotaurRenderer(renderManager).withScale(scale);
    }

    public void preRender(PoseStack poseStack, RiftMinotaur animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    private class MinotaurHeldLayer
    extends BlockAndItemGeoLayer<RiftMinotaur> {
        public MinotaurHeldLayer() {
            super((GeoRenderer)RiftMinotaurRenderer.this);
        }

        protected ItemStack getStackForBone(GeoBone bone, RiftMinotaur animatable) {
            return switch (bone.getName()) {
                case RiftMinotaurRenderer.LEFT_HAND -> {
                    if (animatable.isLeftHanded()) {
                        yield RiftMinotaurRenderer.this.mainHandItem;
                    }
                    yield RiftMinotaurRenderer.this.offhandItem;
                }
                case RiftMinotaurRenderer.RIGHT_HAND -> {
                    if (animatable.isLeftHanded()) {
                        yield RiftMinotaurRenderer.this.offhandItem;
                    }
                    yield RiftMinotaurRenderer.this.mainHandItem;
                }
                default -> null;
            };
        }

        protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, RiftMinotaur animatable) {
            return switch (bone.getName()) {
                case RiftMinotaurRenderer.LEFT_HAND, RiftMinotaurRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                default -> ItemDisplayContext.NONE;
            };
        }

        protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, RiftMinotaur animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
            if (stack == RiftMinotaurRenderer.this.mainHandItem) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.2, 0.15, -0.32);
                poseStack.scale(2.0f, 2.0f, 2.0f);
            } else if (stack == RiftMinotaurRenderer.this.offhandItem) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0, 0.125, -0.5);
                poseStack.scale(2.0f, 2.0f, 2.0f);
            }
            super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
        }
    }
}

