/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.block;

import dev.ftb.mods.ftboceanmobs.FTBOceanMobsTags;
import dev.ftb.mods.ftboceanmobs.registry.ModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnergyGeyserBlock
extends Block {
    private static final VoxelShape COLLISION = EnergyGeyserBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public EnergyGeyserBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Vec3 vec = Vec3.atBottomCenterOf((Vec3i)pos.above());
        if (level.getBlockState(pos.above()).getBlock() instanceof LiquidBlock) {
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, vec.x + (double)(random.nextFloat() * 0.5f) - 0.25, vec.y, vec.z + (double)(random.nextFloat() * 0.5f) - 0.25, 0.0, (double)0.05f, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, vec.x + (double)(random.nextFloat() * 0.5f) - 0.25, vec.y + 1.0, vec.z + (double)(random.nextFloat() * 0.5f) - 0.25, 0.0, (double)0.05f, 0.0);
        } else {
            level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, vec.x + (double)(random.nextFloat() * 0.5f) - 0.25, vec.y, vec.z + (double)(random.nextFloat() * 0.5f) - 0.25, 0.0, (double)0.05f, 0.0);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.getType().is(FTBOceanMobsTags.Entity.RIFT_MOBS)) {
                livingEntity.addEffect(new MobEffectInstance(ModMobEffects.DROWNING_SHADOWS_EFFECT, 60, 1));
            }
        }
    }
}

