/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.config;

import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerType;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public interface ClientConfig {
    public static final SNBTConfig CLIENT_CONFIG = SNBTConfig.create((String)"ftbunearthed-client");
    public static final SNBTConfig GENERAL = CLIENT_CONFIG.addGroup("general");
    public static final StringValue RAW_VILLAGER_TYPE = (StringValue)GENERAL.addString("default_villager_type", "minecraft:plains").comment(new String[]{"Default village type for villager tokens in creative/JEI", "This should be a valid resource location for a village type in the VILLAGER_TYPE registry", "e.g. \"minecraft:plains\", \"minecraft:savanna\" etc., or a custom type such as \"ftb:stone\""});
    public static final Lazy<VillagerType> DEFAULT_VILLAGER_TYPE = Lazy.of(ClientConfig::parseVillagerType);

    @NotNull
    private static VillagerType parseVillagerType() {
        String typeStr = (String)RAW_VILLAGER_TYPE.get();
        try {
            ResourceLocation type = ResourceLocation.parse((String)typeStr);
            return BuiltInRegistries.VILLAGER_TYPE.getOptional(type).orElseGet(() -> {
                FTBUnearthed.LOGGER.error("unknown villager type '{}'", (Object)typeStr);
                return VillagerType.PLAINS;
            });
        }
        catch (ResourceLocationException e) {
            FTBUnearthed.LOGGER.error("invalid villager type '{}'", (Object)typeStr);
            return VillagerType.PLAINS;
        }
    }

    public static void onChanged(boolean onServer) {
        DEFAULT_VILLAGER_TYPE.invalidate();
    }
}

