/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.block;

import dev.ftb.mods.ftbunearthed.block.UneartherCoreBlockEntity;
import dev.ftb.mods.ftbunearthed.registry.ModBlockEntityTypes;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UneartherFrameBlockEntity
extends BlockEntity {
    @NotNull
    private WeakReference<UneartherCoreBlockEntity> core = new WeakReference<Object>(null);
    private BlockPos corePosPending;

    public UneartherFrameBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.UNEARTHER_FRAME.get(), pos, blockState);
    }

    public Optional<UneartherCoreBlockEntity> getCore() {
        if (this.corePosPending != null && this.level != null) {
            this.level.getBlockEntity(this.corePosPending, (BlockEntityType)ModBlockEntityTypes.UNEARTHER_CORE.get()).ifPresentOrElse(core -> {
                this.core = new WeakReference<UneartherCoreBlockEntity>((UneartherCoreBlockEntity)((Object)core));
                this.corePosPending = null;
            }, () -> this.level.destroyBlock(this.getBlockPos(), false, null));
        }
        return Optional.ofNullable((UneartherCoreBlockEntity)((Object)this.core.get()));
    }

    void setCore(@NotNull UneartherCoreBlockEntity core) {
        if (this.core.get() != null) {
            throw new IllegalStateException("core is already set and can't be changed!");
        }
        this.core = new WeakReference<UneartherCoreBlockEntity>(core);
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.corePosPending = NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"CorePos").orElse(null);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.corePosPending != null) {
            compoundTag.put("CorePos", NbtUtils.writeBlockPos((BlockPos)this.corePosPending));
        } else {
            UneartherCoreBlockEntity cs = (UneartherCoreBlockEntity)((Object)this.core.get());
            if (cs != null) {
                compoundTag.put("CorePos", NbtUtils.writeBlockPos((BlockPos)cs.getBlockPos()));
            }
        }
    }

    @Nullable
    public IItemHandler getItemHandler() {
        return this.getCore().map(UneartherCoreBlockEntity::getItemHandler).orElse(null);
    }
}

