/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.apache.commons.lang3.Validate;

public record RegionCoords(int x, int z) {
    public static final Codec<RegionCoords> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(RegionCoords::x), (App)Codec.INT.fieldOf("z").forGetter(RegionCoords::z)).apply((Applicative)inst, RegionCoords::new));
    public static final Codec<RegionCoords> STRING_CODEC = Codec.STRING.comapFlatMap(str -> {
        try {
            return DataResult.success((Object)RegionCoords.fromString(str));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }, RegionCoords::toString);

    public RegionCoords offsetBy(int xOff, int zOff) {
        return new RegionCoords(this.x + xOff, this.z + zOff);
    }

    public RegionCoords offsetBy(XZ offset) {
        return new RegionCoords(this.x + offset.x(), this.z + offset.z());
    }

    public String filename() {
        return String.format("r.%d.%d.mca", this.x, this.z);
    }

    public BlockPos getBlockPos(Vec3i offset) {
        return new BlockPos((this.x << 9) + offset.getX(), offset.getY(), (this.z << 9) + offset.getZ());
    }

    @Override
    public String toString() {
        return "[" + this.x + "," + this.z + "]";
    }

    public static RegionCoords fromString(String str) throws IllegalArgumentException {
        Validate.isTrue((str.startsWith("[") && str.endsWith("]") ? 1 : 0) != 0, (String)("Malformed string: " + str), (Object[])new Object[0]);
        String[] parts = str.substring(1, str.length() - 1).split(",", 2);
        Validate.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Malformed string: " + str), (Object[])new Object[0]);
        return new RegionCoords(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }
}

