/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.definition.JigsawParams;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ProgressiveJigsawPlacer {
    private final CommandSourceStack source;
    private final JigsawParams jigsawParams;
    private final BlockPos startPos;
    private WorkData workData;

    public ProgressiveJigsawPlacer(CommandSourceStack source, JigsawParams jigsawParams, BlockPos startPos) {
        this.source = source;
        this.jigsawParams = jigsawParams;
        this.startPos = startPos;
    }

    public void start(ServerLevel level) {
        level.setBlock(this.startPos, (BlockState)Blocks.JIGSAW.defaultBlockState().setValue((Property)JigsawBlock.ORIENTATION, (Comparable)this.jigsawParams.jigsawOrientation()), 0);
        BlockEntity blockEntity = level.getBlockEntity(this.startPos);
        if (!(blockEntity instanceof JigsawBlockEntity)) {
            throw new FTBTeamBasesException("could not get jigsaw block entity at " + String.valueOf(level.dimension().location()) + " / " + String.valueOf(this.startPos));
        }
        JigsawBlockEntity jbe = (JigsawBlockEntity)blockEntity;
        jbe.setPool(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)this.jigsawParams.templatePool()));
        jbe.setTarget(this.jigsawParams.target());
        jbe.setJoint(this.jigsawParams.jointType());
        this.workData = this.setupPieceQueue(level, jbe, this.jigsawParams.maxGenerationDepth());
    }

    private WorkData setupPieceQueue(ServerLevel level, JigsawBlockEntity jbe, int maxDepth) {
        ChunkGenerator chunkgenerator = level.getChunkSource().getGenerator();
        StructureTemplateManager structuretemplatemanager = level.getStructureManager();
        BlockPos origin = jbe.getBlockPos().relative(((FrontAndTop)jbe.getBlockState().getValue((Property)JigsawBlock.ORIENTATION)).front());
        Structure.GenerationContext context = new Structure.GenerationContext(level.registryAccess(), chunkgenerator, chunkgenerator.getBiomeSource(), level.getChunkSource().randomState(), structuretemplatemanager, level.getSeed(), new ChunkPos(origin), (LevelHeightAccessor)level, biome -> true);
        Holder.Reference holder = level.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL).getHolderOrThrow(jbe.getPool());
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, (Holder)holder, Optional.of(jbe.getTarget()), (int)maxDepth, (BlockPos)origin, (boolean)false, Optional.empty(), (int)128, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING).map(stub -> {
            StructurePiecesBuilder builder = stub.getPiecesBuilder();
            ArrayDeque<WorkUnit> units = new ArrayDeque<WorkUnit>(builder.build().pieces().stream().filter(piece -> piece instanceof PoolElementStructurePiece).map(piece -> new WorkUnit(origin, (PoolElementStructurePiece)piece)).toList());
            return new WorkData(level, units.size(), units);
        }).orElse(null);
    }

    public float getProgress() {
        return 1.0f - (float)this.workData.work().size() / (float)this.workData.totalSize();
    }

    public boolean tick() {
        if (this.workData == null) {
            return true;
        }
        WorkUnit workUnit = this.workData.work().pollFirst();
        if (workUnit == null) {
            return true;
        }
        ServerLevel level = this.workData.level();
        if (level != null) {
            StructureManager structureManager = level.structureManager();
            ChunkGenerator chunkgenerator = level.getChunkSource().getGenerator();
            RandomSource random = level.getRandom();
            workUnit.piece().place((WorldGenLevel)level, structureManager, chunkgenerator, random, BoundingBox.infinite(), workUnit.pos(), false);
            if (this.workData.work.isEmpty()) {
                try {
                    BlockState state = BlockStateParser.parseForBlock((HolderLookup)level.holderLookup(Registries.BLOCK), (String)this.jigsawParams.finalState(), (boolean)false).blockState();
                    level.setBlock(this.startPos, state, 3);
                }
                catch (CommandSyntaxException e) {
                    FTBTeamBases.LOGGER.error("invalid final_state {}, defaulting to AIR", (Object)this.jigsawParams.finalState());
                    level.setBlock(this.startPos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
            return !this.workData.work().isEmpty();
        }
        return true;
    }

    public CommandSourceStack getSource() {
        return this.source;
    }

    private record WorkData(ServerLevel level, int totalSize, Deque<WorkUnit> work) {
    }

    private record WorkUnit(BlockPos pos, PoolElementStructurePiece piece) {
    }
}

