/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.integration;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.AutoClaimShape;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.mutable.MutableInt;

public class AutoClaiming {
    private static final UUID LOBBY_SERVER_ID = UUID.fromString("ddc10a3e-b566-4e84-af66-8c315272ab02");

    public static void handleLobbyAutoclaiming(ServerLevel serverLevel) {
        if ((Integer)ServerConfig.LOBBY_RADIUS.get() == 0 || ServerConfig.lobbyPos().isEmpty()) {
            return;
        }
        String teamName = (String)ServerConfig.LOBBY_SERVER_TEAM_NAME.get();
        Color4I lobbyTeamColor = ServerConfig.getLobbyTeamColor();
        try {
            TeamManager teamMgr = FTBTeamsAPI.api().getManager();
            ClaimedChunkManager chunkMgr = FTBChunksAPI.api().getManager();
            CommandSourceStack serverCmdSource = serverLevel.getServer().createCommandSourceStack();
            Team lobbyTeam = teamMgr.getTeamByID(LOBBY_SERVER_ID).orElse(teamMgr.createServerTeam(serverCmdSource, teamName, null, lobbyTeamColor, LOBBY_SERVER_ID));
            lobbyTeam.setProperty((TeamProperty)TeamProperties.DISPLAY_NAME, (Object)teamName);
            lobbyTeam.setProperty((TeamProperty)TeamProperties.COLOR, (Object)lobbyTeamColor);
            ChunkTeamData chunkTeamData = chunkMgr.getOrCreateData(lobbyTeam);
            chunkTeamData.getClaimedChunks().forEach(cc -> cc.unclaim(serverCmdSource, false));
            MutableInt claimed = new MutableInt(0);
            ((AutoClaimShape)((Object)ServerConfig.LOBBY_SHAPE.get())).forEachChunk(ServerConfig.getClaimCenter(), (Integer)ServerConfig.LOBBY_RADIUS.get(), cp -> {
                ClaimResult claimRes = chunkTeamData.claim(serverCmdSource, new ChunkDimPos(serverLevel.dimension(), cp), false);
                if (!claimRes.isSuccess()) {
                    FTBTeamBases.LOGGER.error("Couldn't autoclaim lobby chunkpos {}: {}", cp, (Object)claimRes.getMessage().getString());
                } else {
                    claimed.increment();
                }
            });
            FTBTeamBases.LOGGER.info("autoclaimed {} chunks around lobby pos {} ({}) for server team {}", (Object)claimed.getValue(), (Object)ServerConfig.lobbyPos().get(), ServerConfig.LOBBY_SHAPE.get(), (Object)lobbyTeam.getShortName());
        }
        catch (CommandSyntaxException e) {
            FTBTeamBases.LOGGER.error("can't create server team {}: {}", (Object)teamName, (Object)e.getMessage());
        }
    }
}

