/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.definition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.net.SyncBaseTemplatesMessage;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BaseDefinitionManager {
    private static final BaseDefinitionManager CLIENT_INSTANCE = new BaseDefinitionManager();
    private static final BaseDefinitionManager SERVER_INSTANCE = new BaseDefinitionManager();
    private final Map<ResourceLocation, BaseDefinition> templates = new ConcurrentHashMap<ResourceLocation, BaseDefinition>();

    public static BaseDefinitionManager getClientInstance() {
        return CLIENT_INSTANCE;
    }

    public static BaseDefinitionManager getServerInstance() {
        return SERVER_INSTANCE;
    }

    public Optional<BaseDefinition> getBaseDefinition(ResourceLocation id) {
        return Optional.ofNullable(this.templates.get(id));
    }

    public Collection<ResourceLocation> getTemplateIds() {
        return this.templates.keySet();
    }

    public Collection<BaseDefinition> getDefinitions() {
        return this.templates.values();
    }

    public void syncFromServer(Collection<BaseDefinition> structures) {
        this.templates.clear();
        structures.forEach(s -> this.templates.put(s.id(), (BaseDefinition)s));
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ReloadListener() {
            super(GSON, "ftb_base_definitions");
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            Map<ResourceLocation, BaseDefinition> serverTemplates = BaseDefinitionManager.getServerInstance().templates;
            serverTemplates.clear();
            object.forEach((id, json) -> BaseDefinition.fromJson(json).ifPresent(s -> serverTemplates.put((ResourceLocation)id, (BaseDefinition)s)));
            FTBTeamBases.LOGGER.info("loaded {} base definitions", (Object)serverTemplates.size());
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncBaseTemplatesMessage(BaseDefinitionManager.getServerInstance().getDefinitions()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

