/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction.workers;

import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.ConstructionWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.Pregen;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RelocatingPregenWorker
implements ConstructionWorker {
    private final RegionFileRelocator relocator;
    private final RegionExtents extents;
    private final ResourceKey<Level> dimensionKey;
    private final XZ regionOffset;

    public RelocatingPregenWorker(ServerPlayer player, BaseDefinition baseDefinition, Pregen pregen) throws IOException {
        CommandSourceStack source = player.createCommandSourceStack();
        MinecraftServer server = source.getServer();
        Path pregenDir = RegionFileUtil.getPregenPath(pregen.templateId(), server, "region");
        this.extents = RegionFileUtil.getRegionExtents(pregenDir).orElseThrow(() -> new FTBTeamBasesException("no region files in " + String.valueOf(pregenDir)));
        this.dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)baseDefinition.dimensionSettings().dimensionId().orElse(FTBTeamBases.SHARED_DIMENSION_ID));
        RegionCoords startRegion = BaseInstanceManager.get(server).nextGenerationPos(server, baseDefinition, this.dimensionKey.location(), this.extents.getSize());
        this.regionOffset = XZ.of((int)(startRegion.x() - this.extents.start().x()), (int)(startRegion.z() - this.extents.start().z()));
        this.relocator = new RegionFileRelocator(source, pregen.templateId(), this.dimensionKey, this.regionOffset, false);
    }

    @Override
    public void tick() {
        ServerPlayer player = this.relocator.getSource().getPlayer();
        if (player != null) {
            int pct = (int)(100.0f * this.relocator.getProgress());
            player.displayClientMessage((Component)Component.literal((String)("Progress: " + pct + "%")), true);
        }
    }

    @Override
    public void startConstruction(BooleanConsumer onCompleted) {
        this.relocator.start(onCompleted);
    }

    @Override
    public RegionExtents getRegionExtents() {
        return new RegionExtents(this.extents.start().offsetBy(this.regionOffset), this.extents.end().offsetBy(this.regionOffset));
    }

    @Override
    public XZ getSpawnXZ() {
        int x1 = (this.extents.start().x() + this.regionOffset.x()) * 512;
        int z1 = (this.extents.start().z() + this.regionOffset.z()) * 512;
        int x2 = (this.extents.end().x() + this.regionOffset.x()) * 512 + 511;
        int z2 = (this.extents.end().z() + this.regionOffset.z()) * 512 + 511;
        return XZ.of((int)(x1 + (x2 - x1) / 2), (int)(z1 + (z2 - z1) / 2));
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionKey;
    }
}

