/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction.workers;

import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.construction.workers.AbstractStructureWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.JigsawParams;
import dev.ftb.mods.ftbteambases.util.ProgressiveJigsawPlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class JigsawWorker
extends AbstractStructureWorker {
    private final ProgressiveJigsawPlacer placer;

    public JigsawWorker(ServerPlayer player, BaseDefinition baseDefinition, JigsawParams jigsawParams, boolean privateDimension) {
        super(player, baseDefinition, privateDimension);
        ServerLevel serverLevel = this.getOrCreateLevel(player.getServer());
        BlockPos origin = this.getPlacementOrigin(serverLevel, this.getSpawnXZ(), jigsawParams.yPos()).offset((Vec3i)jigsawParams.generationOffset().orElse(BlockPos.ZERO));
        this.placer = new ProgressiveJigsawPlacer(player.createCommandSourceStack(), jigsawParams, origin);
    }

    @Override
    public void startConstruction(BooleanConsumer onCompleted) {
        super.startConstruction(onCompleted);
        ServerLevel level = this.getOrCreateLevel(this.placer.getSource().getServer());
        if (level == null) {
            throw new FTBTeamBasesException("Jigsaw Worker: can't get/create dimension " + String.valueOf(this.getDimension().location()));
        }
        this.placer.start(level);
    }

    @Override
    public void tick() {
        boolean done = this.placer.tick();
        ServerPlayer player = this.placer.getSource().getPlayer();
        if (player != null) {
            int pct = (int)(100.0f * this.placer.getProgress());
            player.displayClientMessage((Component)Component.literal((String)("Progress: " + pct + "%")), true);
        }
        if (done) {
            this.onCompleted.accept(true);
        }
    }
}

