/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.bases.LiveBaseDetails;
import dev.ftb.mods.ftbteambases.util.MiscUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ShowCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"show").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestLiveBases(builder)).executes(ctx -> ShowCommand.doShow((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))));
    }

    private static int doShow(CommandSourceStack source, String name) throws CommandSyntaxException {
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamByName(name).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)name));
        LiveBaseDetails base = BaseInstanceManager.get(source.getServer()).getBaseForTeam(team).orElseThrow(() -> CommandUtils.BASE_NOT_FOUND.create((Object)team.getShortName()));
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.show_base_header", (Object[])new Object[]{team.getShortName()}).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}), false);
        source.sendSuccess(Component::empty, false);
        source.sendSuccess(() -> Component.translatable((String)"ftbteams.info.id", (Object[])new Object[]{CommandUtils.colorize(team.getTeamId(), ChatFormatting.YELLOW)}), false);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.base_dimension", (Object[])new Object[]{CommandUtils.colorize(base.dimension().location(), ChatFormatting.YELLOW)}), false);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.base_extents_block", (Object[])new Object[]{CommandUtils.colorize(base.extents().asBlockPosString(), ChatFormatting.YELLOW)}), false);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.base_extents", (Object[])new Object[]{CommandUtils.colorize(base.extents(), ChatFormatting.YELLOW)}), false);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.base_spawn_pos", (Object[])new Object[]{CommandUtils.colorize(MiscUtil.blockPosStr(base.spawnPos()), ChatFormatting.YELLOW)}), false);
        return 1;
    }
}

