/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.util.MiscUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class SetLobbyPosCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setlobbypos").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> SetLobbyPosCommand.setLobbyPos((CommandSourceStack)ctx.getSource(), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"))));
    }

    private static int setLobbyPos(CommandSourceStack source, BlockPos pos) {
        BaseInstanceManager.get(source.getServer()).setLobbySpawnPos(pos, true);
        source.sendSuccess(() -> Component.literal((String)("lobby pos updated to " + MiscUtil.blockPosStr(pos))), false);
        ServerConfig.lobbyDimension().ifPresent(dim -> {
            ServerLevel level = source.getServer().getLevel(dim);
            if (level != null) {
                level.setDefaultSpawnPos(pos, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue());
            }
        });
        return 1;
    }
}

