/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases;

import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftbteambases.TeamEventListener;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.config.ClientConfig;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.BaseConstructionManager;
import dev.ftb.mods.ftbteambases.data.construction.RelocatorTracker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionManager;
import dev.ftb.mods.ftbteambases.data.purging.PurgeManager;
import dev.ftb.mods.ftbteambases.integration.FTBChunksIntegration;
import dev.ftb.mods.ftbteambases.net.SyncBaseTemplatesMessage;
import dev.ftb.mods.ftbteambases.net.VoidTeamDimensionMessage;
import dev.ftb.mods.ftbteambases.registry.ModArgumentTypes;
import dev.ftb.mods.ftbteambases.registry.ModBlocks;
import dev.ftb.mods.ftbteambases.registry.ModSounds;
import dev.ftb.mods.ftbteambases.registry.ModWorldGen;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteambases.util.DynamicDimensionManager;
import dev.ftb.mods.ftbteambases.util.LobbyPregen;
import dev.ftb.mods.ftbteambases.util.MiscUtil;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerRespawnPositionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="ftbteambases")
public class FTBTeamBases {
    public static final String MOD_ID = "ftbteambases";
    public static final Logger LOGGER = LogManager.getLogger((String)"ftbteambases");
    public static final ResourceLocation NO_TEMPLATE_ID = FTBTeamBases.rl("none");
    public static final ResourceLocation SHARED_DIMENSION_ID = FTBTeamBases.rl("bases");

    public FTBTeamBases(IEventBus modBus) {
        try {
            Files.createDirectories(RegionFileRelocator.PREGEN_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("can't create {}: {}", (Object)RegionFileRelocator.PREGEN_PATH, (Object)e.getMessage());
        }
        ModWorldGen.init(modBus);
        ModBlocks.init(modBus);
        ModSounds.init(modBus);
        ModArgumentTypes.init(modBus);
        ConfigManager.getInstance().registerServerConfig(ServerConfig.CONFIG, "server", false);
        ConfigManager.getInstance().registerClientConfig(ClientConfig.CONFIG, "client");
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::serverBeforeStart);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::serverStarting);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::serverStarted);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::serverStopping);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onSleepFinished);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::onLevelLoad);
        NeoForge.EVENT_BUS.addListener(CommandUtils::registerCommands);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::onServerTick);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::playerEnterServer);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::playerJoinLevel);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::playerChangedDimension);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::registerReloadListeners);
        NeoForge.EVENT_BUS.addListener(FTBTeamBases::onPlayerRespawn);
        TeamEvent.PLAYER_JOINED_PARTY.register(TeamEventListener::teamPlayerJoin);
        TeamEvent.PLAYER_LEFT_PARTY.register(TeamEventListener::teamPlayerLeftParty);
        TeamEvent.DELETED.register(TeamEventListener::teamDeleted);
    }

    private static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BaseDefinitionManager.ReloadListener());
    }

    private static void onServerTick(ServerTickEvent.Post event) {
        RelocatorTracker.INSTANCE.tick(event.getServer());
        BaseConstructionManager.INSTANCE.tick(event.getServer());
        DynamicDimensionManager.unregisterScheduledDimensions(event.getServer());
    }

    private static void serverBeforeStart(ServerAboutToStartEvent event) {
        PurgeManager.INSTANCE.init(event.getServer());
    }

    private static void serverStarting(ServerStartingEvent event) {
        FTBTeamsAPI.api().setPartyCreationFromAPIOnly(true);
    }

    private static void serverStarted(ServerStartedEvent event) {
        ServerConfig.lobbyDimension().ifPresent(dim -> {
            if (dim.equals(Level.OVERWORLD)) {
                ServerLevel level = event.getServer().getLevel(Level.OVERWORLD);
                if (level == null) {
                    LOGGER.error("Missed spawn reset event due to overworld being null?!");
                    return;
                }
                BaseInstanceManager mgr = BaseInstanceManager.get(event.getServer());
                if (mgr.isLobbyCreated() && !level.getSharedSpawnPos().equals((Object)mgr.getLobbySpawnPos())) {
                    level.setDefaultSpawnPos(mgr.getLobbySpawnPos(), 180.0f);
                    LOGGER.info("Updating overworld spawn pos to the lobby spawn pos: {}", (Object)mgr.getLobbySpawnPos());
                }
            }
        });
    }

    private static void serverStopping(ServerStoppingEvent server) {
        PurgeManager.INSTANCE.onShutdown();
    }

    private static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (serverLevel.dimension() == Level.OVERWORLD && LobbyPregen.maybePregenLobby(serverLevel.getServer())) {
                FTBChunksIntegration.maybeAutoClaimLobby(serverLevel);
                return;
            }
            ServerConfig.lobbyDimension().ifPresent(rl -> {
                if (serverLevel.dimension().equals(rl)) {
                    FTBTeamBases.maybeCreateLobbyFromStructure(serverLevel);
                    FTBChunksIntegration.maybeAutoClaimLobby(serverLevel);
                }
            });
        }
    }

    private static void playerEnterServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SyncBaseTemplatesMessage.syncTo(player2);
            BaseInstanceManager.get().checkForOrphanedPlayer(player2);
        }
    }

    private static void playerJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                if (FTBTeamBases.isFirstTimeConnecting(player, serverLevel)) {
                    ServerLevel destLevel = ServerConfig.lobbyDimension().map(dim -> serverLevel.getServer().getLevel(dim)).orElse(serverLevel);
                    BlockPos lobbySpawnPos = BaseInstanceManager.get(player.server).getLobbySpawnPos();
                    player.teleportTo(destLevel, (double)lobbySpawnPos.getX(), (double)lobbySpawnPos.getY(), (double)lobbySpawnPos.getZ(), ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue(), -10.0f);
                    BaseInstanceManager.get().addKnownPlayer(player);
                }
                if (DimensionUtils.isVoidChunkGen(serverLevel.getChunkSource().getGenerator())) {
                    VoidTeamDimensionMessage.syncTo(player);
                }
                FTBTeamBases.switchGameMode(player, null, (ResourceKey<Level>)serverLevel.dimension());
            }
        }
    }

    private static boolean isFirstTimeConnecting(ServerPlayer player, ServerLevel level) {
        return level.dimension().equals(Level.OVERWORLD) && player.getRespawnDimension().equals(Level.OVERWORLD) && !BaseInstanceManager.get(player.server).isPlayerKnown(player);
    }

    private static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FTBTeamBases.switchGameMode(player2, (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
            FTBTeamBases.handleNetherTravel(player2, (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }
    }

    private static void switchGameMode(ServerPlayer player, @Nullable ResourceKey<Level> oldDim, ResourceKey<Level> newDim) {
        GameType lobbyGameMode = (GameType)ServerConfig.LOBBY_GAME_MODE.get();
        ResourceKey<Level> lobby = ServerConfig.lobbyDimension().orElse((ResourceKey<Level>)Level.OVERWORLD);
        if (newDim.equals(lobby) && player.gameMode.getGameModeForPlayer() != lobbyGameMode && player.gameMode.getGameModeForPlayer() != GameType.CREATIVE) {
            player.setGameMode(lobbyGameMode);
        } else if (lobby.equals(oldDim) && !newDim.equals(lobby) && player.gameMode.getGameModeForPlayer() == lobbyGameMode) {
            player.setGameMode(GameType.SURVIVAL);
        }
    }

    private static void handleNetherTravel(ServerPlayer player, ResourceKey<Level> oldDim, ResourceKey<Level> newDim) {
        if (player.isOnPortalCooldown()) {
            BaseInstanceManager mgr = BaseInstanceManager.get(player.server);
            if (newDim.equals((Object)Level.NETHER)) {
                BlockPos portalPos = mgr.getBaseForPlayer(player).filter(base -> oldDim.equals(base.dimension())).map(base -> BlockPos.containing((double)player.xOld, (double)player.yOld, (double)player.zOld)).orElse(null);
                mgr.setPlayerNetherPortalLoc(player, portalPos);
            } else if (oldDim.equals((Object)Level.NETHER) && newDim.equals((Object)Level.OVERWORLD)) {
                mgr.getBaseForPlayer(player).ifPresentOrElse(base -> {
                    ResourceKey<Level> teamDim = base.dimension();
                    BlockPos portalPos = mgr.getPlayerNetherPortalLoc(player).orElse(base.spawnPos());
                    DimensionUtils.teleport(player, teamDim, portalPos);
                }, () -> mgr.teleportToLobby(player));
            }
        }
    }

    private static void maybeCreateLobbyFromStructure(ServerLevel serverLevel) {
        BaseInstanceManager mgr = BaseInstanceManager.get(serverLevel.getServer());
        if (!mgr.isLobbyCreated()) {
            ServerConfig.lobbyLocation().ifPresent(lobbyLocation -> {
                StructureTemplate lobby = serverLevel.getStructureManager().getOrCreate(lobbyLocation);
                StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(lobby);
                BlockPos lobbyPos = BlockPos.ZERO.offset(-(lobby.getSize().getX() / 2), ((Integer)ServerConfig.LOBBY_Y_POS.get()).intValue(), -(lobby.getSize().getZ() / 2));
                lobby.placeInWorld((ServerLevelAccessor)serverLevel, lobbyPos, lobbyPos, placeSettings, serverLevel.random, 3);
                BlockPos relativePos = DimensionUtils.findSpawnBlockInStructure(lobby).orElse(BlockPos.ZERO);
                BlockPos playerSpawn = lobbyPos.offset(relativePos.getX(), relativePos.getY(), relativePos.getZ());
                mgr.setLobbySpawnPos(playerSpawn, false);
                serverLevel.removeBlock(playerSpawn, false);
                serverLevel.setDefaultSpawnPos(playerSpawn, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue());
                mgr.setLobbyCreated(true);
                mgr.forceSave(serverLevel.getServer());
                LOGGER.info("Spawned lobby structure @ {} / {}", (Object)serverLevel.dimension().location(), (Object)lobbyPos);
            });
        }
    }

    private void onSleepFinished(SleepFinishedTimeEvent event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimension().location().getNamespace().equals(MOD_ID)) {
            MiscUtil.setOverworldTime(level.getServer(), event.getNewTime());
        }
    }

    private static void onPlayerRespawn(PlayerRespawnPositionEvent event) {
        MinecraftServer server = event.getEntity().getServer();
        if (server != null) {
            BaseInstanceManager mgr = BaseInstanceManager.get(server);
            ServerLevel lobbyLvl = server.getLevel(ServerConfig.lobbyDimension().orElse((ResourceKey<Level>)Level.OVERWORLD));
            if (lobbyLvl != null) {
                event.setDimensionTransition(new DimensionTransition(lobbyLvl, Vec3.atCenterOf((Vec3i)mgr.getLobbySpawnPos()), Vec3.ZERO, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue(), 0.0f, DimensionTransition.DO_NOTHING));
            }
        }
    }

    public static ResourceLocation rl(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

