/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.items;

import com.mojang.serialization.Codec;
import dev.ftb.mods.ftbstuffnthings.items.MeshItem;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MeshType implements StringRepresentable
{
    EMPTY("empty", null, null),
    CLOTH("cloth", ItemsRegistry.CLOTH_MESH, (TagKey<Item>)Tags.Items.STRINGS),
    IRON("iron", ItemsRegistry.IRON_MESH, (TagKey<Item>)Tags.Items.INGOTS_IRON),
    GOLD("gold", ItemsRegistry.GOLD_MESH, (TagKey<Item>)Tags.Items.INGOTS_GOLD),
    DIAMOND("diamond", ItemsRegistry.DIAMOND_MESH, (TagKey<Item>)Tags.Items.GEMS_DIAMOND),
    BLAZING("blazing", ItemsRegistry.BLAZING_MESH, (TagKey<Item>)Tags.Items.RODS_BLAZE);

    public static final Codec<MeshType> CODEC;
    public static final StreamCodec<ByteBuf, MeshType> STREAM_CODEC;
    public static final List<MeshType> NON_EMPTY_VALUES;
    @Nullable
    private final DeferredItem<MeshItem> meshItem;
    private final String name;
    @Nullable
    private final TagKey<Item> ingredientTag;

    private MeshType(@Nullable String name, DeferredItem<MeshItem> meshItem, TagKey<Item> ingredientTag) {
        this.name = name;
        this.meshItem = meshItem;
        this.ingredientTag = ingredientTag;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public ItemStack getItemStack() {
        return this.meshItem == null ? ItemStack.EMPTY : this.meshItem.toStack();
    }

    @Nullable
    public TagKey<Item> getIngredientTag() {
        return this.ingredientTag;
    }

    static {
        CODEC = StringRepresentable.fromEnum(MeshType::values);
        STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        NON_EMPTY_VALUES = Arrays.stream(MeshType.values()).filter(e -> e != EMPTY).toList();
    }
}

