/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.client.screens.SuperCoolerScreen;
import dev.ftb.mods.ftbstuffnthings.crafting.EnergyRequirement;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SuperCoolerRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SuperCoolerCategory
extends BaseStuffCategory<SuperCoolerRecipe> {
    public static final ResourceLocation BACKGROUND = SuperCoolerCategory.bgTexture("jei_super_cooler.png");
    private static final Rect2i CLICK_AREA = new Rect2i(77, 25, 27, 21);
    private final IDrawableAnimated powerBar = SuperCoolerCategory.guiHelper().drawableBuilder(BACKGROUND, 146, 0, 6, 16).setTextureSize(174, 28).buildAnimated(SuperCoolerCategory.guiHelper().createTickTimer(120, 16, false), IDrawableAnimated.StartDirection.BOTTOM);
    private final IDrawableAnimated progress = SuperCoolerCategory.guiHelper().drawableBuilder(BACKGROUND, 152, 0, 22, 16).setTextureSize(174, 28).buildAnimated(SuperCoolerCategory.guiHelper().createTickTimer(120, 22, true), IDrawableAnimated.StartDirection.LEFT);

    public SuperCoolerCategory() {
        super(RecipeTypes.SUPER_COOLER, (Component)Component.translatable((String)"block.ftbstuff.super_cooler"), (IDrawable)SuperCoolerCategory.guiHelper().drawableBuilder(BACKGROUND, 0, 0, 146, 28).setTextureSize(174, 28).build(), SuperCoolerCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemsRegistry.SUPER_COOLER.toStack()));
    }

    @Override
    public void draw(SuperCoolerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        this.powerBar.draw(graphics, 6, 6);
        this.progress.draw(graphics, 97, 6);
        EnergyRequirement energyRequirement = recipe.getEnergyComponent();
        int ticks = energyRequirement.ticksToProcess();
        int energyPerTick = energyRequirement.fePerTick();
        int totalEnergy = ticks * energyPerTick;
        PoseStack stack = graphics.pose();
        stack.pushPose();
        stack.translate(5.0f, 25.0f, 0.0f);
        stack.scale(0.5f, 0.5f, 0.5f);
        graphics.drawString(Minecraft.getInstance().font, "%sFE/t (%sFE)".formatted(energyPerTick, totalEnergy), 0, 0, -1090519041);
        stack.popPose();
        stack.pushPose();
        stack.translate(96.0f, 25.0f, 0.0f);
        stack.scale(0.5f, 0.5f, 0.5f);
        graphics.drawString(Minecraft.getInstance().font, "%s ticks".formatted(ticks), 0, 0, -1090519041);
        stack.popPose();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SuperCoolerRecipe superCoolerRecipe, IFocusGroup iFocusGroup) {
        for (int i = 0; i < superCoolerRecipe.getInputs().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 40 + i * 18, 6).addIngredients(superCoolerRecipe.getInputs().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 6).addItemStack(superCoolerRecipe.getResult());
        List<Fluid> fluids = Arrays.stream(superCoolerRecipe.getFluidInput().getFluids()).map(FluidStack::getFluid).toList();
        if (!fluids.isEmpty()) {
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 18, 6);
            fluids.forEach(fluid -> slotBuilder.addFluidStack(fluid, (long)superCoolerRecipe.getFluidInput().amount()));
            slotBuilder.addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(superCoolerRecipe.getFluidInput().amount() + " mB"))));
        }
    }

    static enum ContainerHandler implements IGuiContainerHandler<SuperCoolerScreen>
    {
        INSTANCE;


        public Collection<IGuiClickableArea> getGuiClickableAreas(SuperCoolerScreen containerScreen, double guiMouseX, double guiMouseY) {
            return List.of(IGuiClickableArea.createBasic((int)CLICK_AREA.getX(), (int)CLICK_AREA.getY(), (int)CLICK_AREA.getWidth(), (int)CLICK_AREA.getHeight(), (RecipeType[])new RecipeType[]{RecipeTypes.SUPER_COOLER}));
        }
    }
}

