/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlock;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemModelsGenerator
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.parse((String)"item/generated");

    public ItemModelsGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ftbstuff", existingFileHelper);
    }

    protected void registerModels() {
        String path = BlocksRegistry.PUMP.getKey().location().getPath();
        ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path + "_on")));
        this.withExistingParent("tube", FTBStuffNThings.id("block/tube_inv"));
        this.withExistingParent("jar", FTBStuffNThings.id("block/jar"));
        this.withExistingParent("tempered_jar", FTBStuffNThings.id("block/tempered_jar_normal"));
        this.withExistingParent("auto_processing_block", FTBStuffNThings.id("block/auto_processing_block"));
        this.withExistingParent("blue_magma_block", FTBStuffNThings.id("block/blue_magma_block"));
        this.withExistingParent("creative_low_temperature_source", this.modLoc("block/creative_low_temperature_source"));
        this.withExistingParent("creative_high_temperature_source", this.modLoc("block/creative_high_temperature_source"));
        this.withExistingParent("creative_subzero_temperature_source", this.modLoc("block/creative_subzero_temperature_source"));
        this.withExistingParent("cast_iron_block", this.modLoc("block/cast_iron_block"));
        this.withExistingParent("iron_auto_hammer", this.modLoc("block/iron_auto_hammer"));
        this.withExistingParent("gold_auto_hammer", this.modLoc("block/gold_auto_hammer"));
        this.withExistingParent("diamond_auto_hammer", this.modLoc("block/diamond_auto_hammer"));
        this.withExistingParent("netherite_auto_hammer", this.modLoc("block/netherite_auto_hammer"));
        this.withExistingParent("dust", this.modLoc("block/dust"));
        this.withExistingParent("crushed_basalt", this.modLoc("block/crushed_basalt"));
        this.withExistingParent("crushed_endstone", this.modLoc("block/crushed_endstone"));
        this.withExistingParent("crushed_netherrack", this.modLoc("block/crushed_netherrack"));
        this.withExistingParent("white_barrel", FTBStuffNThings.id("block/white_barrel"));
        this.withExistingParent("green_barrel", FTBStuffNThings.id("block/green_barrel"));
        this.withExistingParent("blue_barrel", FTBStuffNThings.id("block/blue_barrel"));
        this.withExistingParent("purple_barrel", FTBStuffNThings.id("block/purple_barrel"));
        this.withExistingParent("red_barrel", FTBStuffNThings.id("block/red_barrel"));
        this.withExistingParent("black_barrel", FTBStuffNThings.id("block/black_barrel"));
        this.withExistingParent("golden_barrel", FTBStuffNThings.id("block/golden_barrel"));
        this.withExistingParent("crate", FTBStuffNThings.id("block/crate"));
        this.withExistingParent("small_crate", FTBStuffNThings.id("block/small_crate"));
        this.withExistingParent("pulsating_crate", FTBStuffNThings.id("block/pulsating_crate"));
        this.withExistingParent("stone_cobblestone_generator", this.modLoc("block/stone_cobblestone_generator"));
        this.withExistingParent("iron_cobblestone_generator", this.modLoc("block/iron_cobblestone_generator"));
        this.withExistingParent("gold_cobblestone_generator", this.modLoc("block/gold_cobblestone_generator"));
        this.withExistingParent("diamond_cobblestone_generator", this.modLoc("block/diamond_cobblestone_generator"));
        this.withExistingParent("netherite_cobblestone_generator", this.modLoc("block/netherite_cobblestone_generator"));
        this.withExistingParent("stone_basalt_generator", this.modLoc("block/stone_basalt_generator"));
        this.withExistingParent("iron_basalt_generator", this.modLoc("block/iron_basalt_generator"));
        this.withExistingParent("gold_basalt_generator", this.modLoc("block/gold_basalt_generator"));
        this.withExistingParent("diamond_basalt_generator", this.modLoc("block/diamond_basalt_generator"));
        this.withExistingParent("netherite_basalt_generator", this.modLoc("block/netherite_basalt_generator"));
        this.withExistingParent("cloth_mesh", this.modLoc("block/cloth_mesh"));
        this.withExistingParent("iron_mesh", this.modLoc("block/iron_mesh"));
        this.withExistingParent("gold_mesh", this.modLoc("block/gold_mesh"));
        this.withExistingParent("diamond_mesh", this.modLoc("block/diamond_mesh"));
        this.withExistingParent("blazing_mesh", this.modLoc("block/blazing_mesh"));
        this.withExistingParent("wooden_basin", this.modLoc("block/wooden_basin"));
        BlocksRegistry.waterStrainers().forEach(block -> {
            String type = ((WaterStrainerBlock)((Object)((Object)block.get()))).getWoodType().name();
            this.withExistingParent(type + "_water_strainer", this.modLoc("block/" + type + "_water_strainer"));
        });
        this.simpleItem(ItemsRegistry.FLUID_CAPSULE, "item/fluid_container_base", "item/fluid_container_overlay");
        this.simpleItem(ItemsRegistry.DRIPPER, "item/dripper");
        this.simpleItem(ItemsRegistry.WATER_BOWL, "item/water_bowl");
        this.simpleItem(ItemsRegistry.CAST_IRON_GEAR, "item/cast_iron_gear");
        this.simpleItem(ItemsRegistry.CAST_IRON_INGOT, "item/cast_iron_ingot");
        this.simpleItem(ItemsRegistry.CAST_IRON_NUGGET, "item/cast_iron_nugget");
        this.simpleItem(ItemsRegistry.TEMPERED_GLASS, "item/tempered_glass");
        this.simpleItem(ItemsRegistry.STONE_HAMMER, "item/stone_hammer");
        this.simpleItem(ItemsRegistry.IRON_HAMMER, "item/iron_hammer");
        this.simpleItem(ItemsRegistry.GOLD_HAMMER, "item/gold_hammer");
        this.simpleItem(ItemsRegistry.DIAMOND_HAMMER, "item/diamond_hammer");
        this.simpleItem(ItemsRegistry.NETHERITE_HAMMER, "item/netherite_hammer");
        this.simpleItem(ItemsRegistry.CROOK, "item/stone_crook");
        this.simpleItem(ItemsRegistry.STONE_ROD, "item/stone_rod");
        this.singleTexture("item/oak_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/oak_sluice"));
        this.singleTexture("item/spruce_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/spruce_sluice"));
        this.singleTexture("item/birch_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/birch_sluice"));
        this.singleTexture("item/jungle_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/jungle_sluice"));
        this.singleTexture("item/acacia_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/acacia_sluice"));
        this.singleTexture("item/dark_oak_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/dark_oak_sluice"));
        this.singleTexture("item/mangrove_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/mangrove_sluice"));
        this.singleTexture("item/cherry_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/cherry_sluice"));
        this.singleTexture("item/pale_oak_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/pale_oak_sluice"));
        this.singleTexture("item/crimson_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/crimson_sluice"));
        this.singleTexture("item/warped_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/warped_sluice"));
        this.singleTexture("item/bamboo_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/bamboo_sluice"));
        this.singleTexture("item/iron_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/iron_sluice"));
        this.singleTexture("item/diamond_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/diamond_sluice"));
        this.singleTexture("item/netherite_sluice", this.modLoc("item/sluice"), "0", this.modLoc("block/sluice/netherite_sluice"));
        BlocksRegistry.allCompressedBlocks().forEach(db -> this.simpleBlockItem((Block)db.get()));
    }

    private ItemModelBuilder simpleItem(DeferredItem<? extends Item> item, String ... textures) {
        return this.simpleItem(item.getId(), textures);
    }

    private ItemModelBuilder simpleItem(ResourceLocation itemKey, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemKey.getPath(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }
}

