/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.EnergyRequirement;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;

public class FusingMachineRecipe
extends BaseRecipe<FusingMachineRecipe> {
    private final List<Ingredient> inputs;
    private final FluidStack fluidResult;
    private final EnergyRequirement energyRequirement;

    public FusingMachineRecipe(List<Ingredient> inputs, FluidStack fluidResult, EnergyRequirement energyRequirement) {
        super(RecipesRegistry.FUSING_MACHINE_SERIALIZER, RecipesRegistry.FUSING_MACHINE_TYPE);
        this.inputs = inputs;
        this.fluidResult = fluidResult;
        this.energyRequirement = energyRequirement;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public FluidStack getFluidResult() {
        return this.fluidResult;
    }

    public EnergyRequirement getEnergyComponent() {
        return this.energyRequirement;
    }

    public boolean test(IItemHandler itemHandler) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.getInputs());
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(itemHandler.getStackInSlot(i))) continue;
                iter.remove();
                ++found;
                break;
            }
            if (found != this.getInputs().size()) continue;
            return true;
        }
        return false;
    }

    public static class Serializer<T extends FusingMachineRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("inputs").forGetter(FusingMachineRecipe::getInputs), (App)FluidStack.CODEC.fieldOf("result").forGetter(FusingMachineRecipe::getFluidResult), (App)EnergyRequirement.CODEC.fieldOf("energy").forGetter(FusingMachineRecipe::getEnergyComponent)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), FusingMachineRecipe::getInputs, (StreamCodec)FluidStack.STREAM_CODEC, FusingMachineRecipe::getFluidResult, EnergyRequirement.STREAM_CODEC, FusingMachineRecipe::getEnergyComponent, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends FusingMachineRecipe> {
        public T create(List<Ingredient> var1, FluidStack var2, EnergyRequirement var3);
    }
}

