/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeCache<R extends Recipe<?>> {
    private static final int MAX_CACHE_SIZE = 1024;
    private final Int2ObjectLinkedOpenHashMap<Optional<RecipeHolder<R>>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    public Optional<RecipeHolder<R>> getCachedRecipe(Supplier<Optional<RecipeHolder<R>>> recipeFinder, IntSupplier hashCodeGenerator) {
        int key = hashCodeGenerator.getAsInt();
        if (this.recipeCache.containsKey(key)) {
            return (Optional)this.recipeCache.getAndMoveToFirst(key);
        }
        Optional<RecipeHolder<R>> newRecipe = recipeFinder.get();
        while (this.recipeCache.size() >= 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, newRecipe);
        return newRecipe;
    }

    void clear() {
        this.recipeCache.clear();
    }
}

