/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.jar;

import dev.ftb.mods.ftbstuffnthings.blocks.jar.JarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import dev.ftb.mods.ftbstuffnthings.temperature.TemperatureAndEfficiency;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TemperedJarBlock
extends JarBlock {
    public static final EnumProperty<Temperature> TEMPERATURE = EnumProperty.create((String)"temperature", Temperature.class);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public TemperedJarBlock() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TEMPERATURE, (Comparable)((Object)Temperature.NORMAL))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TemperedJarBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TEMPERATURE, ACTIVE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        TemperatureAndEfficiency tempEff = TemperatureAndEfficiency.fromLevel(context.getLevel(), context.getClickedPos().below());
        return (BlockState)this.defaultBlockState().setValue(TEMPERATURE, (Comparable)((Object)tempEff.temperature()));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, be) -> {
            if (be instanceof TemperedJarBlockEntity) {
                TemperedJarBlockEntity jar = (TemperedJarBlockEntity)be;
                if (level1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level1;
                    jar.serverTick(serverLevel);
                }
            }
        };
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState blockState;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TemperedJarBlockEntity) {
            TemperedJarBlockEntity jar = (TemperedJarBlockEntity)blockEntity;
            if (direction == Direction.DOWN || direction == Direction.UP) {
                jar.clearCachedData();
            }
        }
        if (direction == Direction.DOWN && level instanceof Level) {
            Level l = (Level)level;
            blockState = (BlockState)state.setValue(TEMPERATURE, (Comparable)((Object)TemperatureAndEfficiency.fromLevel(l, neighborPos).temperature()));
        } else {
            blockState = state;
        }
        return blockState;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemStack item = player.getItemInHand(hand);
        if (hitResult.getDirection() == Direction.UP && item.getItem() == ItemsRegistry.TUBE.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TemperedJarBlockEntity) {
            TemperedJarBlockEntity jar = (TemperedJarBlockEntity)blockEntity;
            if (!player.isShiftKeyDown()) {
                if (!jar.onRightClick(player, hand)) {
                    player.openMenu((MenuProvider)jar, buf -> {
                        buf.writeBlockPos(pos);
                        buf.writeOptional(jar.getCurrentRecipeId(), FriendlyByteBuf::writeResourceLocation);
                    });
                }
            } else {
                jar.maybeClearBacklog(hitResult.getDirection());
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            Temperature temperature = (Temperature)((Object)state.getValue(TEMPERATURE));
            for (int i = 0; i < 12; ++i) {
                if (level.random.nextInt(4) != 0) continue;
                float angle = (float)i / 12.0f * ((float)Math.PI * 2);
                double x = (double)pos.getX() + 0.5 + (double)Mth.cos((float)angle) * 0.25;
                double y = (float)pos.getY() + temperature.getParticleYOffset();
                double z = (double)pos.getZ() + 0.5 + (double)Mth.sin((float)angle) * 0.25;
                level.addParticle(temperature.getParticleOptions(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        list.add(ComponentsRegistry.FLUID_TANKS.get());
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TemperedJarBlockEntity) {
                TemperedJarBlockEntity jar = (TemperedJarBlockEntity)blockEntity;
                jar.dropContentsOnBreak();
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List l = (List)stack.getOrDefault(ComponentsRegistry.FLUID_TANKS, List.of());
        l.forEach(content -> tooltipComponents.add(MiscUtil.makeFluidStackDesc(content.copy())));
    }
}

