/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.cobblegen;

import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.CobblegenBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.IResourceGenProps;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public enum CobblegenProperties implements IResourceGenProps
{
    STONE(Config.STONE_COBBLEGEN_AMOUNT, CobblegenBlockEntity.Stone::new),
    IRON(Config.IRON_COBBLEGEN_AMOUNT, CobblegenBlockEntity.Iron::new),
    GOLD(Config.GOLD_COBBLEGEN_AMOUNT, CobblegenBlockEntity.Gold::new),
    DIAMOND(Config.DIAMOND_COBBLEGEN_AMOUNT, CobblegenBlockEntity.Diamond::new),
    NETHERITE(Config.NETHERITE_COBBLEGEN_AMOUNT, CobblegenBlockEntity.Netherite::new);

    private final IntValue cobblegenSpeed;
    private final BiFunction<BlockPos, BlockState, ? extends CobblegenBlockEntity> beFactory;

    private CobblegenProperties(IntValue cobblegenSpeed, BiFunction<BlockPos, BlockState, ? extends CobblegenBlockEntity> beFactory) {
        this.cobblegenSpeed = cobblegenSpeed;
        this.beFactory = beFactory;
    }

    @Override
    public int itemsPerOperation() {
        return (Integer)this.cobblegenSpeed.get();
    }

    @Override
    public BlockEntity createBlockEntity(BlockPos pos, BlockState blockState) {
        return this.beFactory.apply(pos, blockState);
    }
}

