/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import com.google.gson.JsonParseException;
import dev.ftb.mods.ftblibrary.util.client.ClientTextComponentUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;

public class TextUtils {
    private static final UnicodeUnescaper UNESCAPER = new UnicodeUnescaper();

    public static Component parseRawText(String str, HolderLookup.Provider provider) {
        String str2 = str.trim();
        if (str2.startsWith("[") && str2.endsWith("]") || str2.startsWith("{") && str2.endsWith("}")) {
            try {
                MutableComponent res = Component.Serializer.fromJson((String)UNESCAPER.translate((CharSequence)str2), (HolderLookup.Provider)provider);
                if (res != null) {
                    return res;
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return ClientTextComponentUtils.parse((String)UNESCAPER.translate((CharSequence)str));
    }

    public static List<String> fromListTag(ListTag tag) {
        ArrayList<String> res = new ArrayList<String>();
        tag.forEach(el -> {
            if (el.getId() == 8) {
                res.add(el.getAsString());
            }
        });
        return res;
    }

    public static boolean isComponentEmpty(Component c) {
        return c.getSiblings().isEmpty() && c.getContents() == PlainTextContents.EMPTY;
    }
}

