/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.forcedgamerule;

import dev.ftb.packcompanion.config.PCCommonConfig;
import dev.ftb.packcompanion.core.Feature;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForcedGameRulesFeature
extends Feature.Common {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForcedGameRulesFeature.class);

    public ForcedGameRulesFeature(IEventBus modEventBus, ModContainer container) {
        super(modEventBus, container);
        NeoForge.EVENT_BUS.addListener(this::onLevelLoad);
    }

    public void onLevelLoad(ServerStartedEvent event) {
        final Map forcedGameRules = (Map)PCCommonConfig.GAME_RULE_MAPPING.get();
        final MinecraftServer server = event.getServer();
        GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                if (forcedGameRules.containsKey(key.getId())) {
                    Tag value = (Tag)forcedGameRules.get(key.getId());
                    if (value instanceof ByteTag) {
                        boolean asBoolean;
                        ByteTag byteTag = (ByteTag)value;
                        GameRules.BooleanValue rule = (GameRules.BooleanValue)server.getGameRules().getRule(key);
                        boolean bl = asBoolean = byteTag.getAsByte() != 0;
                        if (rule.get() != asBoolean) {
                            LOGGER.info("Setting (bool) game rule '{}' to {}", (Object)key.getId(), (Object)asBoolean);
                            rule.set(asBoolean, server);
                        }
                    } else if (value instanceof IntTag) {
                        IntTag intTag = (IntTag)value;
                        GameRules.IntegerValue rule = (GameRules.IntegerValue)server.getGameRules().getRule(key);
                        if (rule.get() != intTag.getAsInt()) {
                            LOGGER.info("Setting (int) game rule '{}' to {}", (Object)key.getId(), (Object)intTag.getAsInt());
                            rule.set(intTag.getAsInt(), server);
                        }
                    }
                }
            }
        });
    }
}

