/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config.values;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.packcompanion.config.values.CustomSpreadFactors;
import dev.ftb.packcompanion.config.values.SparseStructuresConfig;
import java.util.ArrayList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class SparseStructuresValue
extends BaseValue<SparseStructuresConfig> {
    public SparseStructuresValue(@Nullable SNBTConfig c, String n, SparseStructuresConfig def) {
        super(c, n, (Object)def);
    }

    public void write(SNBTCompoundTag compoundTag) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.comment("enabled", "Whether sparse structures are enabled.");
        tag.putBoolean("enabled", ((SparseStructuresConfig)this.get()).enabled());
        tag.comment("global_spread_factor", "The global spread factor for all structures when no custom spread factor is defined.");
        tag.putDouble("global_spread_factor", ((SparseStructuresConfig)this.get()).globalSpreadFactor());
        ListTag list = new ListTag();
        for (CustomSpreadFactors custom : ((SparseStructuresConfig)this.get()).customSpreadFactors()) {
            SNBTCompoundTag customTag = new SNBTCompoundTag();
            customTag.putString("structure", custom.structure());
            customTag.putDouble("spread_factor", custom.spreadFactor());
            list.add((Object)customTag);
        }
        tag.comment("custom_spread_factors", "Custom spread factors for specific structures.");
        tag.put("custom_spread_factors", (Tag)list);
        compoundTag.comment(this.key, "Sparse structures configuration. See https://github.com/MCTeamPotato/SparseStructuresReforged/tree/1201 for more information.");
        compoundTag.put(this.key, (Tag)tag);
    }

    public void read(SNBTCompoundTag parent) {
        if (!parent.contains(this.key)) {
            this.set(SparseStructuresConfig.DEFAULT);
            return;
        }
        SNBTCompoundTag tag = (SNBTCompoundTag)parent.get(this.key);
        if (tag == null) {
            this.set(SparseStructuresConfig.DEFAULT);
            return;
        }
        boolean enabled = tag.getBoolean("enabled");
        double globalSpreadFactor = tag.getDouble("global_spread_factor");
        ArrayList<CustomSpreadFactors> customSpreadFactors = new ArrayList<CustomSpreadFactors>();
        if (tag.contains("custom_spread_factors")) {
            ListTag listTag = tag.getList("custom_spread_factors", 10);
            for (Tag customTag : listTag) {
                SNBTCompoundTag compound = (SNBTCompoundTag)customTag;
                customSpreadFactors.add(new CustomSpreadFactors(compound.getString("structure"), compound.getDouble("spread_factor")));
            }
        }
        this.set(new SparseStructuresConfig(enabled, globalSpreadFactor, customSpreadFactors));
    }
}

