/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.dev.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.ftb.mods.ftbmaterials.resources.Resource;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistry;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistryHolder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructAllResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstructAllResources.class);

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"construct-all-resources").requires(e -> e.hasPermission(4))).executes(ConstructAllResources::construct);
    }

    private static int construct(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = player.blockPosition();
        int xOffset = 0;
        int yOffset = 0;
        for (Resource resource : Resource.values()) {
            Optional<ResourceRegistryHolder> resourceHolder = ResourceRegistry.RESOURCE_REGISTRY_HOLDERS.stream().filter(e -> e.getType().equals((Object)resource)).findFirst();
            if (resourceHolder.isEmpty()) {
                LOGGER.warn("Unable to find {} in registry holders", (Object)resource);
                continue;
            }
            ResourceRegistryHolder resourceRegistryHolder = resourceHolder.get();
            for (RegistrySupplier block : resourceRegistryHolder.getBlocks()) {
                Block actualBlock = (Block)block.get();
                level.setBlock(pos.relative(Direction.UP, yOffset).relative(Direction.NORTH, xOffset), actualBlock.defaultBlockState(), 3);
                ++yOffset;
            }
            for (RegistrySupplier item : resourceRegistryHolder.getItems()) {
                BlockPos relativeLocation = pos.relative(Direction.UP, yOffset).relative(Direction.NORTH, xOffset);
                level.setBlock(relativeLocation, Blocks.STONE.defaultBlockState(), 3);
                ItemFrame itemFrame = new ItemFrame((Level)level, relativeLocation.relative(Direction.EAST), Direction.EAST);
                ItemStack itemStack = new ItemStack((ItemLike)item.get());
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)((Item)item.get()).getName(itemStack));
                itemFrame.setItem(itemStack);
                itemFrame.setCustomNameVisible(true);
                level.addFreshEntity((Entity)itemFrame);
                ++yOffset;
            }
            ++xOffset;
            yOffset = 0;
        }
        return 0;
    }
}

