/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.net;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.block.entity.EchoProjectorBlockEntity;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SelectEchoMessage(BlockPos projectorPos, ResourceLocation echoId) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, SelectEchoMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SelectEchoMessage::projectorPos, (StreamCodec)ResourceLocation.STREAM_CODEC, SelectEchoMessage::echoId, SelectEchoMessage::new);
    public static final CustomPacketPayload.Type<SelectEchoMessage> TYPE = new CustomPacketPayload.Type(FTBEchoes.id("select_echo"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(SelectEchoMessage message, IPayloadContext context) {
        ServerPlayer sp;
        Player player = context.player();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2) && sp.isCreative() && (player = sp.level().getBlockEntity(message.projectorPos)) instanceof EchoProjectorBlockEntity) {
            EchoProjectorBlockEntity projector = (EchoProjectorBlockEntity)player;
            EchoManager.getServerInstance().getEcho(message.echoId).ifPresent(echo -> projector.setEchoId(echo.id()));
        }
    }
}

