/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.integration.jei;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.client.ShopSummary;
import dev.ftb.mods.ftbechoes.integration.jei.FTBEchoesJEIPlugin;
import dev.ftb.mods.ftbechoes.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbechoes.registry.ModBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ShoppingCategory
implements IRecipeCategory<ShopSummary.SummaryItem> {
    private static final ResourceLocation BG_TEXTURE = FTBEchoes.id("textures/gui/jei_shopping.png");
    public static final ResourceLocation MONEY_BAG = ResourceLocation.fromNamespaceAndPath((String)"ftblibrary", (String)"textures/icons/money_bag.png");
    private static final int OUTPUT_SLOTS = 4;
    private final IDrawable background = FTBEchoesJEIPlugin.guiHelper().drawableBuilder(BG_TEXTURE, 0, 0, 128, 32).setTextureSize(128, 32).build();
    private final IDrawable moneyIcon = FTBEchoesJEIPlugin.guiHelper().drawableBuilder(MONEY_BAG, 0, 0, 16, 16).setTextureSize(16, 16).build();

    public RecipeType<ShopSummary.SummaryItem> getRecipeType() {
        return RecipeTypes.SHOPPING;
    }

    public Component getTitle() {
        return Component.translatable((String)"ftbechoes.jei.shop.title");
    }

    @Nullable
    public IDrawable getIcon() {
        return FTBEchoesJEIPlugin.guiHelper().createDrawableItemStack(ModBlocks.ECHO_PROJECTOR.toStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShopSummary.SummaryItem recipe, IFocusGroup focuses) {
        for (int i = 0; i < 4; ++i) {
            IRecipeSlotBuilder b = builder.addOutputSlot(42 + i * 18, 8);
            if (i >= recipe.data().stacks().size()) continue;
            b.addItemStack(recipe.data().stacks().get(i));
        }
    }

    public void draw(ShopSummary.SummaryItem recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.moneyIcon.draw(guiGraphics, 5, 8);
        String costStr = String.valueOf(recipe.data().cost());
        Font font = Minecraft.getInstance().font;
        int w = font.width(costStr);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(4.0f + (float)(18 - w) / 2.0f, 15.0f, 0.0f);
        guiGraphics.drawString(font, costStr, -1, 0, 0, false);
        guiGraphics.drawString(font, costStr, 1, 0, 0, false);
        guiGraphics.drawString(font, costStr, 0, -1, 0, false);
        guiGraphics.drawString(font, costStr, 0, 1, 0, false);
        guiGraphics.drawString(font, costStr, 0, 0, -2039808, false);
        guiGraphics.pose().popPose();
    }

    public void getTooltip(ITooltipBuilder tooltip, ShopSummary.SummaryItem recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        recipe.data().stacks().forEach(stack -> tooltip.add((FormattedText)stack.getHoverName().copy().withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE})));
        recipe.data().description().forEach(arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
        recipe.data().command().ifPresent(cmd -> cmd.description().forEach(arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0)));
        tooltip.add((FormattedText)Component.translatable((String)"ftbechoes.jei.echo_title", (Object[])new Object[]{recipe.echoTitle()}).withStyle(ChatFormatting.GRAY));
        tooltip.add((FormattedText)Component.translatable((String)"ftbechoes.jei.stage_title", (Object[])new Object[]{recipe.stageTitle()}).withStyle(ChatFormatting.GRAY));
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 32;
    }
}

